/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.internal.usertask.event.KogitoUserTaskEventSupport;
import org.kie.kogito.usertask.UserTaskEventListener;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.events.UserTaskAssignmentEvent;
import org.kie.kogito.usertask.events.UserTaskAttachmentEvent;
import org.kie.kogito.usertask.events.UserTaskCommentEvent;
import org.kie.kogito.usertask.events.UserTaskDeadlineEvent;
import org.kie.kogito.usertask.events.UserTaskStateEvent;
import org.kie.kogito.usertask.events.UserTaskVariableEvent;
import org.kie.kogito.usertask.impl.events.UserTaskAssignmentEventImpl;
import org.kie.kogito.usertask.impl.events.UserTaskAttachmentEventImpl;
import org.kie.kogito.usertask.impl.events.UserTaskCommentEventImpl;
import org.kie.kogito.usertask.impl.events.UserTaskDeadlineEventImpl;
import org.kie.kogito.usertask.impl.events.UserTaskStateEventImpl;
import org.kie.kogito.usertask.impl.events.UserTaskVariableEventImpl;
import org.kie.kogito.usertask.lifecycle.UserTaskState;
import org.kie.kogito.usertask.model.Attachment;
import org.kie.kogito.usertask.model.Comment;

public class KogitoUserTaskEventSupportImpl
implements KogitoUserTaskEventSupport {
    private List<UserTaskEventListener> listeners;
    private IdentityProvider identityProvider;

    public KogitoUserTaskEventSupportImpl(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        this.listeners = new CopyOnWriteArrayList<UserTaskEventListener>();
    }

    private void notifyAllListeners(Consumer<UserTaskEventListener> consumer) {
        this.listeners.forEach(consumer::accept);
    }

    public void fireOnUserTaskNotStartedDeadline(UserTaskInstance userTaskInstance, Map<String, Object> notification) {
        this.fireUserTaskNotification(userTaskInstance, notification, UserTaskDeadlineEvent.DeadlineType.Started);
    }

    public void fireOnUserTaskNotCompletedDeadline(UserTaskInstance userTaskInstance, Map<String, Object> notification) {
        this.fireUserTaskNotification(userTaskInstance, notification, UserTaskDeadlineEvent.DeadlineType.Completed);
    }

    private void fireUserTaskNotification(UserTaskInstance userTaskInstance, Map<String, Object> notification, UserTaskDeadlineEvent.DeadlineType type) {
        UserTaskDeadlineEventImpl event = new UserTaskDeadlineEventImpl(userTaskInstance, notification, type, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onUserTaskDeadline(event));
    }

    public void fireOneUserTaskStateChange(UserTaskInstance userTaskInstance, UserTaskState oldStatus, UserTaskState newStatus) {
        UserTaskStateEventImpl event = new UserTaskStateEventImpl(userTaskInstance, oldStatus, newStatus, this.identityProvider.getName());
        event.setOldStatus(oldStatus);
        event.setNewStatus(newStatus);
        this.notifyAllListeners(l -> l.onUserTaskState((UserTaskStateEvent)event));
    }

    public void fireOnUserTaskAssignmentChange(UserTaskInstance userTaskInstance, KogitoUserTaskEventSupport.AssignmentType assignmentType, Set<String> oldUsersId, Set<String> newUsersId) {
        UserTaskAssignmentEventImpl event = new UserTaskAssignmentEventImpl(userTaskInstance, assignmentType.name(), oldUsersId, newUsersId, this.identityProvider.getName());
        event.setAssignmentType(assignmentType.name());
        this.notifyAllListeners(l -> l.onUserTaskAssignment((UserTaskAssignmentEvent)event));
    }

    public void fireOnUserTaskInputVariableChange(UserTaskInstance userTaskInstance, String variableName, Object newValue, Object oldValue) {
        UserTaskVariableEventImpl event = new UserTaskVariableEventImpl(userTaskInstance, variableName, oldValue, newValue, UserTaskVariableEvent.VariableEventType.INPUT, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onUserTaskInputVariable((UserTaskVariableEvent)event));
    }

    public void fireOnUserTaskOutputVariableChange(UserTaskInstance userTaskInstance, String variableName, Object newValue, Object oldValue) {
        UserTaskVariableEventImpl event = new UserTaskVariableEventImpl(userTaskInstance, variableName, oldValue, newValue, UserTaskVariableEvent.VariableEventType.OUTPUT, this.identityProvider.getName());
        this.notifyAllListeners(l -> l.onUserTaskOutputVariable((UserTaskVariableEvent)event));
    }

    public void fireOnUserTaskAttachmentAdded(UserTaskInstance userTaskInstance, Attachment addedAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setNewAttachment(addedAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentAdded((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskAttachmentChange(UserTaskInstance userTaskInstance, Attachment oldAttachment, Attachment newAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setOldAttachment(oldAttachment);
        event.setNewAttachment(newAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentChange((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskAttachmentDeleted(UserTaskInstance userTaskInstance, Attachment deletedAttachment) {
        UserTaskAttachmentEventImpl event = new UserTaskAttachmentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setOldAttachment(deletedAttachment);
        this.notifyAllListeners(l -> l.onUserTaskAttachmentDeleted((UserTaskAttachmentEvent)event));
    }

    public void fireOnUserTaskCommentAdded(UserTaskInstance userTaskInstance, Comment addedComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setNewComment(addedComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentAdded((UserTaskCommentEvent)event));
    }

    public void fireOnUserTaskCommentChange(UserTaskInstance userTaskInstance, Comment oldComment, Comment newComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setOldComment(oldComment);
        event.setNewComment(newComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentChange((UserTaskCommentEvent)event));
    }

    public void fireOnUserTaskCommentDeleted(UserTaskInstance userTaskInstance, Comment deletedComment) {
        UserTaskCommentEventImpl event = new UserTaskCommentEventImpl(userTaskInstance, this.identityProvider.getName());
        event.setOldComment(deletedComment);
        this.notifyAllListeners(l -> l.onUserTaskCommentDeleted((UserTaskCommentEvent)event));
    }

    public void reset() {
        this.listeners.clear();
    }

    public void addEventListener(UserTaskEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(UserTaskEventListener listener) {
        this.listeners.remove(listener);
    }
}

