/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.impl.lifecycle;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.usertask.UserTaskAssignmentStrategy;
import org.kie.kogito.usertask.UserTaskInstance;
import org.kie.kogito.usertask.UserTaskInstanceNotAuthorizedException;
import org.kie.kogito.usertask.impl.DefaultUserTaskInstance;
import org.kie.kogito.usertask.impl.lifecycle.DefaultUserTaskTransitionToken;
import org.kie.kogito.usertask.impl.lifecycle.DefaultUserTransition;
import org.kie.kogito.usertask.lifecycle.UserTaskLifeCycle;
import org.kie.kogito.usertask.lifecycle.UserTaskState;
import org.kie.kogito.usertask.lifecycle.UserTaskTransition;
import org.kie.kogito.usertask.lifecycle.UserTaskTransitionException;
import org.kie.kogito.usertask.lifecycle.UserTaskTransitionToken;

public class DefaultUserTaskLifeCycle
implements UserTaskLifeCycle {
    public static final String WORKFLOW_ENGINE_USER = "WORKFLOW_ENGINE_USER";
    public static final String PARAMETER_USER = "USER";
    public static final String PARAMETER_NOTIFY = "NOTIFY";
    public static final String ACTIVATE = "activate";
    public static final String CLAIM = "claim";
    public static final String RELEASE = "release";
    public static final String COMPLETE = "complete";
    public static final String SKIP = "skip";
    public static final String FAIL = "fail";
    public static final String REASSIGN = "reassign";
    public static final UserTaskState INACTIVE = UserTaskState.initalized();
    public static final UserTaskState ACTIVE = UserTaskState.of((String)"Ready");
    public static final UserTaskState RESERVED = UserTaskState.of((String)"Reserved");
    public static final UserTaskState COMPLETED = UserTaskState.of((String)"Completed", (UserTaskState.TerminationType)UserTaskState.TerminationType.COMPLETED);
    public static final UserTaskState ERROR = UserTaskState.of((String)"Error", (UserTaskState.TerminationType)UserTaskState.TerminationType.ERROR);
    public static final UserTaskState OBSOLETE = UserTaskState.of((String)"Obsolete", (UserTaskState.TerminationType)UserTaskState.TerminationType.OBSOLETE);
    private final UserTaskTransition T_NEW_ACTIVE = new DefaultUserTransition("activate", INACTIVE, ACTIVE, this::activate);
    private final UserTaskTransition T_ACTIVE_RESERVED = new DefaultUserTransition("claim", ACTIVE, RESERVED, this::claim);
    private final UserTaskTransition T_ACTIVE_SKIPPED = new DefaultUserTransition("skip", ACTIVE, OBSOLETE, this::skip);
    private final UserTaskTransition T_ACTIVE_ERROR = new DefaultUserTransition("fail", ACTIVE, ERROR, this::fail);
    private final UserTaskTransition T_RESERVED_ACTIVE = new DefaultUserTransition("release", RESERVED, ACTIVE, this::release);
    private final UserTaskTransition T_RESERVED_COMPLETED = new DefaultUserTransition("complete", RESERVED, COMPLETED, this::complete);
    private final UserTaskTransition T_RESERVED_SKIPPED = new DefaultUserTransition("skip", RESERVED, OBSOLETE, this::skip);
    private final UserTaskTransition T_RESERVED_ERROR = new DefaultUserTransition("fail", RESERVED, ERROR, this::fail);
    private final UserTaskTransition T_RESERVED_ACTIVE_R = new DefaultUserTransition("reassign", RESERVED, ACTIVE, this::reassign);
    private final UserTaskTransition T_ACTIVE_ACTIVE_R = new DefaultUserTransition("reassign", ACTIVE, ACTIVE, this::reassign);
    private List<UserTaskTransition> transitions = List.of(this.T_NEW_ACTIVE, this.T_ACTIVE_RESERVED, this.T_ACTIVE_SKIPPED, this.T_ACTIVE_ERROR, this.T_RESERVED_ACTIVE, this.T_RESERVED_COMPLETED, this.T_RESERVED_SKIPPED, this.T_RESERVED_ERROR, this.T_RESERVED_ACTIVE_R, this.T_ACTIVE_ACTIVE_R);

    public List<UserTaskTransition> allowedTransitions(UserTaskInstance userTaskInstance, IdentityProvider identity) {
        this.checkPermission(userTaskInstance, identity);
        return this.transitions.stream().filter(t -> t.source().equals((Object)userTaskInstance.getStatus())).toList();
    }

    public Optional<UserTaskTransitionToken> transition(UserTaskInstance userTaskInstance, UserTaskTransitionToken userTaskTransitionToken, IdentityProvider identityProvider) {
        this.checkPermission(userTaskInstance, identityProvider);
        UserTaskTransition transition = this.transitions.stream().filter(t -> t.source().equals((Object)userTaskInstance.getStatus()) && t.id().equals(userTaskTransitionToken.transitionId())).findFirst().orElseThrow(() -> new UserTaskTransitionException("Invalid transition from " + userTaskInstance.getStatus()));
        return transition.executor().execute(userTaskInstance, userTaskTransitionToken, identityProvider);
    }

    public Optional<UserTaskTransitionToken> newReassignmentTransitionToken(UserTaskInstance userTaskInstance, Map<String, Object> data) {
        try {
            return Optional.of(this.newTransitionToken(REASSIGN, userTaskInstance.getStatus(), data));
        }
        catch (UserTaskTransitionException e) {
            return Optional.empty();
        }
    }

    public UserTaskTransitionToken newCompleteTransitionToken(UserTaskInstance userTaskInstance, Map<String, Object> data) {
        return this.newTransitionToken(COMPLETE, userTaskInstance.getStatus(), data);
    }

    public UserTaskTransitionToken newAbortTransitionToken(UserTaskInstance userTaskInstance, Map<String, Object> data) {
        return this.newTransitionToken(FAIL, userTaskInstance.getStatus(), data);
    }

    public UserTaskTransitionToken newTransitionToken(String transitionId, UserTaskInstance userTaskInstance, Map<String, Object> data) {
        return this.newTransitionToken(transitionId, userTaskInstance.getStatus(), data);
    }

    public UserTaskTransitionToken newTransitionToken(String transitionId, UserTaskState state, Map<String, Object> data) {
        UserTaskTransition transition = this.transitions.stream().filter(e -> e.source().equals((Object)state) && e.id().equals(transitionId)).findAny().orElseThrow(() -> new RuntimeException("Invalid transition " + transitionId + " from " + state));
        return new DefaultUserTaskTransitionToken(transition.id(), transition.source(), transition.target(), data);
    }

    public Optional<UserTaskTransitionToken> reassign(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        userTaskInstance.stopNotStartedDeadlines();
        userTaskInstance.stopNotStartedReassignments();
        userTaskInstance.stopNotCompletedDeadlines();
        userTaskInstance.stopNotCompletedReassignments();
        userTaskInstance.startNotCompletedDeadlines();
        userTaskInstance.startNotCompletedReassignments();
        String user = this.assignStrategy(userTaskInstance, identityProvider);
        if (user != null) {
            return Optional.of(this.newTransitionToken(CLAIM, ACTIVE, Map.of(PARAMETER_USER, user)));
        }
        userTaskInstance.startNotStartedDeadlines();
        userTaskInstance.startNotStartedReassignments();
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> activate(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        userTaskInstance.startNotCompletedDeadlines();
        userTaskInstance.startNotCompletedReassignments();
        String user = this.assignStrategy(userTaskInstance, identityProvider);
        if (user != null) {
            return Optional.of(this.newTransitionToken(CLAIM, ACTIVE, Map.of(PARAMETER_USER, user)));
        }
        userTaskInstance.startNotStartedDeadlines();
        userTaskInstance.startNotStartedReassignments();
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> claim(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        if (userTaskInstance instanceof DefaultUserTaskInstance) {
            DefaultUserTaskInstance defaultUserTaskInstance = (DefaultUserTaskInstance)userTaskInstance;
            if (token.data().containsKey(PARAMETER_USER)) {
                defaultUserTaskInstance.setActualOwner((String)token.data().get(PARAMETER_USER));
            } else {
                defaultUserTaskInstance.setActualOwner(identityProvider.getName());
            }
        }
        userTaskInstance.stopNotStartedDeadlines();
        userTaskInstance.stopNotStartedReassignments();
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> release(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        if (userTaskInstance instanceof DefaultUserTaskInstance) {
            DefaultUserTaskInstance defaultUserTaskInstance = (DefaultUserTaskInstance)userTaskInstance;
            defaultUserTaskInstance.setActualOwner(null);
        }
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> complete(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        token.data().forEach((arg_0, arg_1) -> ((UserTaskInstance)userTaskInstance).setOutput(arg_0, arg_1));
        userTaskInstance.stopNotStartedDeadlines();
        userTaskInstance.stopNotStartedReassignments();
        userTaskInstance.stopNotCompletedDeadlines();
        userTaskInstance.stopNotCompletedReassignments();
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> skip(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        if (token.data().containsKey(PARAMETER_NOTIFY)) {
            userTaskInstance.getMetadata().put(PARAMETER_NOTIFY, token.data().get(PARAMETER_NOTIFY));
        }
        userTaskInstance.stopNotStartedDeadlines();
        userTaskInstance.stopNotStartedReassignments();
        userTaskInstance.stopNotCompletedDeadlines();
        userTaskInstance.stopNotCompletedReassignments();
        return Optional.empty();
    }

    public Optional<UserTaskTransitionToken> fail(UserTaskInstance userTaskInstance, UserTaskTransitionToken token, IdentityProvider identityProvider) {
        if (token.data().containsKey(PARAMETER_NOTIFY)) {
            userTaskInstance.getMetadata().put(PARAMETER_NOTIFY, token.data().get(PARAMETER_NOTIFY));
        }
        userTaskInstance.stopNotStartedDeadlines();
        userTaskInstance.stopNotStartedReassignments();
        userTaskInstance.stopNotCompletedDeadlines();
        userTaskInstance.stopNotCompletedReassignments();
        return Optional.empty();
    }

    private String assignStrategy(UserTaskInstance userTaskInstance, IdentityProvider identityProvider) {
        UserTaskAssignmentStrategy assignmentStrategy = userTaskInstance.getUserTask().getAssignmentStrategy();
        return assignmentStrategy.computeAssignment(userTaskInstance, identityProvider).orElse(null);
    }

    private void checkPermission(UserTaskInstance userTaskInstance, IdentityProvider identityProvider) {
        String user = identityProvider.getName();
        Collection roles = identityProvider.getRoles();
        if (WORKFLOW_ENGINE_USER.equals(user)) {
            return;
        }
        Set adminUsers = userTaskInstance.getAdminUsers();
        if (adminUsers.contains(user)) {
            return;
        }
        HashSet userAdminGroups = new HashSet(userTaskInstance.getAdminGroups());
        userAdminGroups.retainAll(roles);
        if (!userAdminGroups.isEmpty()) {
            return;
        }
        if (userTaskInstance.getActualOwner() != null && userTaskInstance.getActualOwner().equals(user)) {
            return;
        }
        if (List.of(INACTIVE, ACTIVE).contains(userTaskInstance.getStatus())) {
            HashSet users = new HashSet(userTaskInstance.getPotentialUsers());
            users.removeAll(userTaskInstance.getExcludedUsers());
            if (users.contains(identityProvider.getName())) {
                return;
            }
            HashSet userPotGroups = new HashSet(userTaskInstance.getPotentialGroups());
            userPotGroups.retainAll(roles);
            if (!userPotGroups.isEmpty()) {
                return;
            }
        }
        throw new UserTaskInstanceNotAuthorizedException("user " + user + " with roles " + roles + " not authorized to perform an operation on user task " + userTaskInstance.getId());
    }
}

