/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.mutiny.core.Vertx;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.job.recipient.common.http.HTTPRequest;
import org.kie.kogito.job.recipient.common.http.HTTPRequestExecutor;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.executor.JobExecutor;
import org.kie.kogito.jobs.service.model.JobDetails;

@ApplicationScoped
public class HttpJobExecutor
extends HTTPRequestExecutor<HttpRecipient<?>>
implements JobExecutor {
    @Inject
    public HttpJobExecutor(@ConfigProperty(name="kogito.job.recipient.http.timeout-in-millis") long timeout, Vertx vertx, ObjectMapper objectMapper) {
        super(timeout, vertx, objectMapper);
    }

    @PostConstruct
    public void initialize() {
        super.initialize();
    }

    public Class<HttpRecipient> type() {
        return HttpRecipient.class;
    }

    protected HttpRecipient<?> getRecipient(JobDetails job) {
        if (job.getRecipient().getRecipient() instanceof HttpRecipient) {
            return (HttpRecipient)job.getRecipient().getRecipient();
        }
        throw new IllegalArgumentException("HttpRecipient is expected for job " + job);
    }

    protected HTTPRequest buildRequest(HttpRecipient<?> recipient, String limit) {
        return HTTPRequest.builder().url(recipient.getUrl()).method(recipient.getMethod()).headers(recipient.getHeaders()).queryParams(recipient.getQueryParams()).addQueryParam("limit", limit).body(recipient.getPayload() != null ? recipient.getPayload().getData() : null).build();
    }
}

