/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management;

import java.net.URI;
import java.util.Objects;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.api.URIBuilder;

public abstract class RestJobsService
implements JobsService {
    public static final String JOBS_PATH = "/jobs";
    private URI jobsServiceUri;
    private String callbackEndpoint;

    public RestJobsService(String jobServiceUrl, String callbackEndpoint) {
        this.jobsServiceUri = Objects.nonNull(jobServiceUrl) ? this.buildJobsServiceURI(jobServiceUrl) : null;
        this.callbackEndpoint = callbackEndpoint;
    }

    public String getCallbackEndpoint(ProcessInstanceJobDescription description) {
        return URIBuilder.toURI((String)(this.callbackEndpoint + "/management/jobs/" + description.processId() + "/instances/" + description.processInstanceId() + "/timers/" + description.id())).toString();
    }

    private URI buildJobsServiceURI(String jobServiceUrl) {
        return URIBuilder.toURI((String)(jobServiceUrl + JOBS_PATH));
    }

    public URI getJobsServiceUri() {
        return this.jobsServiceUri;
    }

    public Job buildJob(ProcessInstanceJobDescription description, String callback) {
        return JobBuilder.builder().id(description.id()).expirationTime(description.expirationTime().get()).repeatInterval(description.expirationTime().repeatInterval()).repeatLimit(description.expirationTime().repeatLimit()).priority(Integer.valueOf(0)).callbackEndpoint(callback).processId(description.processId()).processInstanceId(description.processInstanceId()).rootProcessId(description.rootProcessId()).rootProcessInstanceId(description.rootProcessInstanceId()).nodeInstanceId(description.nodeInstanceId()).build();
    }
}

