/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.time.TimerInstance;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/management/jobs")
public class CallbackJobsServiceResource {
    @Autowired
    Processes processes;
    @Autowired
    Application application;

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/timers/{timerId}")
    @Consumes(value={"application/json"})
    public Response triggerTimer(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="timerId") String timerId, @QueryParam(value="limit") @DefaultValue(value="0") Integer limit) {
        if (processId == null || processInstanceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Process id and Process instance id must be given").build();
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process with id " + processId + " not found")).build();
        }
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId);
            if (!processInstanceFound.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process instance with id " + processInstanceId + " not found")).build();
            }
            ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
            String[] ids = timerId.split("_");
            processInstance.send(Sig.of((String)"timerTriggered", (Object)TimerInstance.with((long)Long.parseLong(ids[1]), (String)timerId, (Integer)limit)));
            return Response.status((Response.Status)Response.Status.OK).build();
        });
    }
}

