/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import javax.annotation.PostConstruct;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringRestJobsService
implements JobsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRestJobsService.class);
    public static final String JOBS_PATH = "/jobs";
    @Value(value="${kogito.jobs-service.url}")
    String jobServiceUrl;
    @Value(value="${kogito.service.url}")
    String callbackEndpoint;
    @Autowired(required=false)
    private RestTemplate restTemplate;

    @PostConstruct
    public void initialize() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            LOGGER.debug("No RestTemplate found, creating a default one");
        }
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        throw new UnsupportedOperationException("Scheduling for process jobs is not yet implemented");
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        String callback = this.callbackEndpoint + "/management/jobs/" + description.processId() + "/instances/" + description.processInstanceId() + "/timers/" + description.id();
        LOGGER.debug("Job to be scheduled {} with callback URL {}", (Object)description, (Object)callback);
        Job job = JobBuilder.builder().id(description.id()).expirationTime(description.expirationTime().get()).repeatInterval(description.expirationTime().repeatInterval()).repeatLimit(description.expirationTime().repeatLimit()).priority(Integer.valueOf(0)).callbackEndpoint(callback).processId(description.processId()).processInstanceId(description.processInstanceId()).rootProcessId(description.rootProcessId()).rootProcessInstanceId(description.rootProcessInstanceId()).build();
        ResponseEntity result = this.restTemplate.postForEntity(this.jobServiceUrl + JOBS_PATH, (Object)job, String.class, new Object[0]);
        if (result.getStatusCode().ordinal() == 200) {
            LOGGER.debug("Creating of the job {} done with status code {} ", (Object)job, (Object)result.getStatusCode());
        }
        return job.getId();
    }

    public boolean cancelJob(String id) {
        try {
            this.restTemplate.delete(this.jobServiceUrl + JOBS_PATH + "/{id}", new Object[]{id});
            return true;
        }
        catch (RestClientException e) {
            LOGGER.debug("Exceltion thrown during canceling of job {}", (Object)id, (Object)e);
            return false;
        }
    }
}

