/*
 * Copyright 2023 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.jobs.service.api.recipient.sink.serialization;

import java.io.IOException;

import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipient;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class ContentModeDeserializer extends JsonDeserializer<SinkRecipient.ContentMode> {

    @Override
    public SinkRecipient.ContentMode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return SinkRecipient.ContentMode.parse(jsonParser.getText());
    }
}
