/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.kogito.jobs.service.api.Descriptor;
import org.kie.kogito.jobs.service.api.Recipient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDescriptorRegistry<T extends Descriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDescriptorRegistry.class);
    protected final LinkedHashSet<T> descriptors = new LinkedHashSet();
    protected final Class<T> clazz;

    protected AbstractDescriptorRegistry(Class<T> clazz) {
        this.clazz = clazz;
        this.loadDescriptors();
    }

    public Set<T> getDescriptors() {
        return this.descriptors;
    }

    public Optional<T> getDescriptor(Recipient<?> recipient) {
        return this.getDescriptors().stream().filter(descr -> descr.getType().isInstance(recipient)).findFirst();
    }

    protected void loadDescriptors() {
        LOGGER.debug("Loading recipient descriptor registry");
        ServiceLoader<T> loader = ServiceLoader.load(this.clazz);
        loader.iterator().forEachRemaining(descriptor -> {
            LOGGER.debug("adding -> ({}) to registry", descriptor);
            this.descriptors.add(descriptor);
        });
        LOGGER.debug("total descriptors: {}", (Object)this.descriptors.size());
    }
}

