/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Retry;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;

@Schema(name="JobV2", description="Defines a job that can be managed by the jobs service.", requiredProperties={"schedule", "retry", "recipient"})
@JsonPropertyOrder(value={"id", "correlationId", "state", "schedule", "retry", "recipient", "executionTimeout", "executionTimeoutUnit"})
public class Job {
    static final String ID_PROPERTY = "id";
    static final String CORRELATION_ID_PROPERTY = "correlationId";
    static final String STATE_PROPERTY = "state";
    static final String SCHEDULE_PROPERTY = "schedule";
    static final String RETRY_PROPERTY = "retry";
    static final String RECIPIENT_PROPERTY = "recipient";
    static final String EXECUTION_TIMEOUT_PROPERTY = "executionTimeout";
    static final String EXECUTION_TIMEOUT_UNIT_PROPERTY = "executionTimeoutUnit";
    @Schema(description="The unique identifier of the job in the system, this value is set by the jobs service.")
    private String id;
    @Schema(description="Logical user provided identifier of the job in the system.")
    private String correlationId;
    private State state;
    private Schedule schedule;
    private Retry retry;
    private Recipient<?> recipient;
    @Schema(description="Optional configuration that establishes the time limit for the current Job execution attempt to finish. When this timeout is exceeded the execution attempt is considered as failed, and depending on the Job retry  configuration, the execution can be retried or the Job will be marked as ERROR. Every Recipient type has a default timeout configuration that will apply automatically if this value is not set, and a maximum timeout configuration that can not be exceeded by current value.")
    private Long executionTimeout;
    @Schema(description="The unit for the executionTimeout. If the executionTimeout is set and the unit is left empty MILLISECONDS are assumed. If the unit is set and the executionTimeout is left empty this value is ignored.")
    private TemporalUnit executionTimeoutUnit;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    public Recipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(Recipient recipient) {
        this.recipient = recipient;
    }

    public Long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public void setExecutionTimeout(Long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public TemporalUnit getExecutionTimeoutUnit() {
        return this.executionTimeoutUnit;
    }

    public void setExecutionTimeoutUnit(TemporalUnit executionTimeoutUnit) {
        this.executionTimeoutUnit = executionTimeoutUnit;
    }

    public String toString() {
        return "Job{id='" + this.id + "', correlationId='" + this.correlationId + "', state=" + this.state + ", schedule=" + this.schedule + ", retry=" + this.retry + ", recipient=" + this.recipient + ", executionTimeout=" + this.executionTimeout + ", executionTimeoutUnit=" + this.executionTimeoutUnit + "}";
    }

    public static Builder builder() {
        return new Builder(new Job());
    }

    public static class Builder {
        private final Job job;

        private Builder(Job job) {
            this.job = job;
        }

        public Builder id(String id) {
            this.job.setId(id);
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.job.setCorrelationId(correlationId);
            return this;
        }

        public Builder state(State state) {
            this.job.setState(state);
            return this;
        }

        public Builder schedule(Schedule schedule) {
            this.job.setSchedule(schedule);
            return this;
        }

        public Builder retry(Retry retry) {
            this.job.setRetry(retry);
            return this;
        }

        public Builder recipient(Recipient<?> recipient) {
            this.job.setRecipient(recipient);
            return this;
        }

        public Builder executionTimeout(Long executionTimeout) {
            this.job.setExecutionTimeout(executionTimeout);
            return this;
        }

        public Builder executionTimeoutUnit(TemporalUnit timeoutUnit) {
            this.job.setExecutionTimeoutUnit(timeoutUnit);
            return this;
        }

        public Job build() {
            return this.job;
        }
    }

    @Schema(description="Available states for a Job.")
    public static enum State {
        SCHEDULED,
        RETRY,
        EXECUTED,
        ERROR,
        CANCELED;

    }
}

