/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.TemporalUnit;

@Schema(description="The retry configuration establishes the number of times a failing job execution must be retried before it\u2019s considered as FAILED.")
@JsonPropertyOrder(value={"maxRetries", "delay", "delayUnit", "maxDuration", "durationUnit"})
public class Retry {
    static final String MAX_RETRIES_PROPERTY = "maxRetries";
    static final String DELAY_PROPERTY = "delay";
    static final String DELAY_UNIT_PROPERTY = "delayUnit";
    static final String MAX_DURATION_PROPERTY = "maxDuration";
    static final String DURATION_UNIT_PROPERTY = "durationUnit";
    @Schema(description="Number of retries to execute in case of failures.", defaultValue="3")
    private Integer maxRetries = 3;
    @Schema(description="Time delay between the retries.", defaultValue="0")
    private Long delay = 0L;
    private TemporalUnit delayUnit = TemporalUnit.MILLIS;
    @Schema(description="Maximum amount of time to continue retrying if no successful execution was produced.", defaultValue="180000")
    private Long maxDuration = 180000L;
    private TemporalUnit durationUnit = TemporalUnit.MILLIS;

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public TemporalUnit getDelayUnit() {
        return this.delayUnit;
    }

    public void setDelayUnit(TemporalUnit delayUnit) {
        this.delayUnit = delayUnit;
    }

    public Long getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(Long maxDuration) {
        this.maxDuration = maxDuration;
    }

    public TemporalUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TemporalUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public String toString() {
        return "Retry{maxRetries=" + this.maxRetries + ", delay=" + this.delay + ", delayUnit='" + this.delayUnit + "', maxDuration=" + this.maxDuration + ", durationUnit='" + this.durationUnit + "'}";
    }

    public static Builder builder() {
        return new Builder(new Retry());
    }

    public static class Builder {
        private final Retry retry;

        private Builder(Retry retry) {
            this.retry = retry;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.retry.setMaxRetries(maxRetries);
            return this;
        }

        public Builder delay(Long delay) {
            this.retry.setDelay(delay);
            return this;
        }

        public Builder delayUnit(TemporalUnit delayUnit) {
            this.retry.setDelayUnit(delayUnit);
            return this;
        }

        public Builder maxDuration(Long maxDuration) {
            this.retry.setMaxDuration(maxDuration);
            return this;
        }

        public Builder durationUnit(TemporalUnit durationUnit) {
            this.retry.setDurationUnit(durationUnit);
            return this;
        }

        public Retry build() {
            return this.retry;
        }
    }
}

