/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.cloudevents.CloudEventAttributes;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.jobs.service.api.serlialization.SpecVersionDeserializer;
import org.kie.kogito.jobs.service.api.serlialization.SpecVersionSerializer;

@JsonPropertyOrder(value={"id", "source", "type", "time", "subject", "specversion", "datacontenttype", "dataschema"})
public abstract class JobCloudEvent<T>
implements CloudEventAttributes {
    public static final SpecVersion SPEC_VERSION = SpecVersion.V1;
    @JsonDeserialize(using=SpecVersionDeserializer.class)
    @JsonSerialize(using=SpecVersionSerializer.class)
    @JsonProperty(value="specversion")
    private SpecVersion specVersion = SPEC_VERSION;
    private String id;
    private URI source;
    private String type;
    private OffsetDateTime time;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonProperty(value="datacontenttype")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataContentType;
    @JsonProperty(value="dataschema")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private URI dataSchema;
    private T data;

    protected JobCloudEvent() {
    }

    public URI getSource() {
        return this.source;
    }

    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public T getData() {
        return this.data;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public URI getDataSchema() {
        return this.dataSchema;
    }

    public String getSubject() {
        return this.subject;
    }

    @JsonIgnore
    public Object getAttribute(String attributeName) throws IllegalArgumentException {
        switch (attributeName) {
            case "specversion": {
                return this.specVersion;
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.dataContentType;
            }
            case "dataschema": {
                return this.dataSchema;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
        }
        throw new IllegalArgumentException("Spec version v1 doesn't have attribute named " + attributeName);
    }

    @JsonIgnore
    public Set<String> getAttributeNames() {
        return super.getAttributeNames();
    }

    public void setSpecVersion(SpecVersion specVersion) {
        this.specVersion = specVersion;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDataContentType(String dataContentType) {
        this.dataContentType = dataContentType;
    }

    public void setDataSchema(URI dataSchema) {
        this.dataSchema = dataSchema;
    }

    public void setData(T data) {
        this.data = data;
    }

    protected void assertExpectedType(String currentType, String expectedType) {
        if (!Objects.equals(currentType, expectedType)) {
            throw new IllegalArgumentException(this.getClass().getName() + " don't support other event type than: " + expectedType + ", please don't use this value: " + currentType);
        }
    }

    public String toString() {
        return "JobCloudEvent{specVersion=" + this.specVersion + ", id='" + this.id + "', source=" + this.source + ", type='" + this.type + "', time=" + this.time + ", subject='" + this.subject + "', dataContentType='" + this.dataContentType + "', dataSchema=" + this.dataSchema + ", data=" + this.data + "}";
    }
}

