/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.event.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import java.io.IOException;
import java.util.Objects;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.JobLookupId;
import org.kie.kogito.jobs.service.api.event.CreateJobEvent;
import org.kie.kogito.jobs.service.api.event.DeleteJobEvent;
import org.kie.kogito.jobs.service.api.event.JobCloudEvent;
import org.kie.kogito.jobs.service.api.serlialization.DeserializationException;
import org.kie.kogito.jobs.service.api.serlialization.SerializationUtils;

public class JobCloudEventDeserializer {
    private final ObjectMapper objectMapper;

    public JobCloudEventDeserializer() {
        this.objectMapper = SerializationUtils.DEFAULT_OBJECT_MAPPER;
    }

    public JobCloudEventDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        SerializationUtils.registerDescriptors(objectMapper);
    }

    public JobCloudEvent<?> deserialize(byte[] data) {
        try {
            CloudEvent cloudEvent = (CloudEvent)this.objectMapper.readValue(data, CloudEvent.class);
            return this.deserialize(cloudEvent);
        }
        catch (IOException e) {
            throw new DeserializationException("An error was produced during a JobCloudEvent deserialization: " + e.getMessage(), e);
        }
    }

    public JobCloudEvent<?> deserialize(CloudEvent cloudEvent) {
        try {
            if (cloudEvent.getSpecVersion() != JobCloudEvent.SPEC_VERSION) {
                throw new DeserializationException("JobCloudEvents are expected to be in the CloudEvent specversion: " + JobCloudEvent.SPEC_VERSION);
            }
            CloudEventData cloudEventData = Objects.requireNonNull(cloudEvent.getData(), "JobCloudEvent data field must not be null");
            if (cloudEvent.getType().equals("job.create")) {
                Job job = (Job)this.objectMapper.readValue(cloudEventData.toBytes(), Job.class);
                return ((CreateJobEvent.Builder)CreateJobEvent.builder().withValuesFrom(cloudEvent)).job(job).build();
            }
            if (cloudEvent.getType().equals("job.delete")) {
                JobLookupId lookupId = (JobLookupId)this.objectMapper.readValue(cloudEventData.toBytes(), JobLookupId.class);
                return ((DeleteJobEvent.Builder)DeleteJobEvent.builder().withValuesFrom(cloudEvent)).lookupId(lookupId).build();
            }
            throw new DeserializationException("Unknown JobCloudEvent event type: " + cloudEvent.getType());
        }
        catch (IOException e) {
            throw new DeserializationException("An error was produced during a JobCloudEvent deserialization: " + e.getMessage(), e);
        }
    }
}

