/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.recipient.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.recipient.kafka.KafkaRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.kafka.KafkaRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.kafka.KafkaRecipientStringPayloadData;

@Schema(description="Recipient definition that delivers a kafka message that contains the configured \"payload\".", allOf={Recipient.class}, requiredProperties={"bootstrapServers", "topicName", "payload"})
@JsonPropertyOrder(value={"bootstrapServers", "topicName", "headers", "payload"})
public class KafkaRecipient<T extends KafkaRecipientPayloadData<?>>
extends Recipient<T> {
    static final String BOOTSTRAP_SERVERS_PROPERTY = "bootstrapServers";
    static final String TOPIC_NAME_PROPERTY = "topicName";
    static final String HEADERS_PROPERTY = "headers";
    @Schema(description="A comma-separated list of host:port to use to establish the connection to the kafka cluster.")
    private String bootstrapServers;
    @Schema(description="Topic name for the message delivery.")
    private String topicName;
    @Schema(description="Headers to send with the kafka message.")
    private Map<String, String> headers = new HashMap<String, String>();
    @JsonProperty(value="payload")
    private T payload;

    @Override
    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers != null ? headers : new HashMap();
    }

    public KafkaRecipient<T> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public String toString() {
        return "KafkaRecipient{bootstrapServers='" + this.bootstrapServers + "', topicName='" + this.topicName + "', headers=" + this.headers + ", payload=" + this.payload + "} " + super.toString();
    }

    public static BuilderSelector builder() {
        return new BuilderSelector();
    }

    public static class Builder<P extends KafkaRecipientPayloadData<?>> {
        private final KafkaRecipient<P> recipient;

        private Builder(KafkaRecipient<P> recipient) {
            this.recipient = recipient;
        }

        public Builder<P> payload(P payload) {
            this.recipient.setPayload(payload);
            return this;
        }

        public Builder<P> bootstrapServers(String bootstrapServers) {
            this.recipient.setBootstrapServers(bootstrapServers);
            return this;
        }

        public Builder<P> topicName(String topicName) {
            this.recipient.setTopicName(topicName);
            return this;
        }

        public Builder<P> header(String name, String value) {
            this.recipient.addHeader(name, value);
            return this;
        }

        public KafkaRecipient<P> build() {
            return this.recipient;
        }
    }

    public static class BuilderSelector {
        private BuilderSelector() {
        }

        public Builder<KafkaRecipientStringPayloadData> forStringPayload() {
            return new Builder<KafkaRecipientStringPayloadData>(new KafkaRecipient());
        }

        public Builder<KafkaRecipientBinaryPayloadData> forBinaryPayload() {
            return new Builder<KafkaRecipientBinaryPayloadData>(new KafkaRecipient());
        }
    }
}

