/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.recipient.sink;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.serialization.ContentModeDeserializer;
import org.kie.kogito.jobs.service.api.recipient.sink.serialization.ContentModeSerializer;
import org.kie.kogito.jobs.service.api.serlialization.SpecVersionDeserializer;
import org.kie.kogito.jobs.service.api.serlialization.SpecVersionSerializer;
import org.kie.kogito.jobs.service.api.utils.EventUtils;

@Schema(description="Recipient definition that delivers a cloud event to a knative sink.", allOf={Recipient.class}, requiredProperties={"sinkUrl", "contentMode", "ce-specversion", "ce-source", "ce-type"})
@JsonPropertyOrder(value={"sinkUrl", "contentMode", "ce-specversion", "ce-source", "ce-type", "ce-subject", "ce-datacontenttype", "ce-dataschema", "ce-extensions", "payload"})
public class SinkRecipient<T extends SinkRecipientPayloadData<?>>
extends Recipient<T> {
    static final String SINK_URL_PROPERTY = "sinkUrl";
    static final String CONTENT_MODE_PROPERTY = "contentMode";
    static final String CE_SPECVERSION = "ce-specversion";
    static final String CE_SOURCE = "ce-source";
    static final String CE_TYPE = "ce-type";
    static final String CE_SUBJECT = "ce-subject";
    static final String CE_DATACONTENTTYPE = "ce-datacontenttype";
    static final String CE_DATASCHEMA = "ce-dataschema";
    static final String CE_EXTENSIONS = "ce-extensions";
    public static final SpecVersion SPEC_VERSION = SpecVersion.V1;
    @Schema(description="Url of the knative sink that will receive the cloud event.")
    private String sinkUrl;
    @JsonDeserialize(using=ContentModeDeserializer.class)
    @JsonSerialize(using=ContentModeSerializer.class)
    private ContentMode contentMode = ContentMode.BINARY;
    @JsonDeserialize(using=SpecVersionDeserializer.class)
    @JsonSerialize(using=SpecVersionSerializer.class)
    @JsonProperty(value="ce-specversion")
    private SpecVersion ceSpecVersion = SPEC_VERSION;
    @JsonProperty(value="ce-source")
    private URI ceSource;
    @JsonProperty(value="ce-type")
    private String ceType;
    @JsonProperty(value="ce-subject")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String ceSubject;
    @JsonProperty(value="ce-datacontenttype")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String ceDataContentType;
    @JsonProperty(value="ce-dataschema")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private URI ceDataSchema;
    @JsonProperty(value="ce-extensions")
    private Map<String, Object> ceExtensions = new HashMap<String, Object>();
    @JsonProperty(value="payload")
    @Schema(ref="#/components/schemas/SinkRecipientPayloadData")
    private T payload;

    public String getSinkUrl() {
        return this.sinkUrl;
    }

    public void setSinkUrl(String sinkUrl) {
        this.sinkUrl = sinkUrl;
    }

    public ContentMode getContentMode() {
        return this.contentMode;
    }

    public void setContentMode(ContentMode contentMode) {
        this.contentMode = contentMode;
    }

    public SpecVersion getCeSpecVersion() {
        return this.ceSpecVersion;
    }

    public void setCeSpecVersion(SpecVersion ceSpecVersion) {
        this.ceSpecVersion = ceSpecVersion;
    }

    public URI getCeSource() {
        return this.ceSource;
    }

    public void setCeSource(URI ceSource) {
        this.ceSource = ceSource;
    }

    public String getCeType() {
        return this.ceType;
    }

    public void setCeType(String ceType) {
        this.ceType = ceType;
    }

    public String getCeSubject() {
        return this.ceSubject;
    }

    public void setCeSubject(String ceSubject) {
        this.ceSubject = ceSubject;
    }

    public String getCeDataContentType() {
        return this.ceDataContentType;
    }

    public void setCeDataContentType(String ceDataContentType) {
        this.ceDataContentType = ceDataContentType;
    }

    public URI getCeDataSchema() {
        return this.ceDataSchema;
    }

    public void setCeDataSchema(URI ceDataSchema) {
        this.ceDataSchema = ceDataSchema;
    }

    public Map<String, Object> getCeExtensions() {
        return this.ceExtensions;
    }

    public void setCeExtensions(Map<String, Object> ceExtensions) {
        this.ceExtensions = ceExtensions != null ? ceExtensions : new HashMap();
    }

    public SinkRecipient<T> addCeExtension(String name, Object value) {
        EventUtils.validateExtensionName(name);
        this.ceExtensions.put(name, value);
        return this;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public String toString() {
        return "SinkRecipient{sinkUrl='" + this.sinkUrl + "', contentMode=" + this.contentMode + ", ceSpecVersion=" + this.ceSpecVersion + ", ceSource=" + this.ceSource + ", ceType='" + this.ceType + "', ceSubject='" + this.ceSubject + "', ceDataContentType='" + this.ceDataContentType + "', ceDataSchema=" + this.ceDataSchema + ", ceExtensions=" + this.ceExtensions + ", payload=" + this.payload + "} " + super.toString();
    }

    public static BuilderSelector builder() {
        return new BuilderSelector();
    }

    public static class Builder<P extends SinkRecipientPayloadData<?>> {
        private final SinkRecipient<P> recipient;

        private Builder(SinkRecipient<P> recipient) {
            this.recipient = recipient;
        }

        public Builder<P> payload(P payload) {
            this.recipient.setPayload(payload);
            return this;
        }

        public Builder<P> sinkUrl(String sinkUrl) {
            this.recipient.setSinkUrl(sinkUrl);
            return this;
        }

        public Builder<P> contentMode(ContentMode contentMode) {
            this.recipient.setContentMode(contentMode);
            return this;
        }

        public Builder<P> ceSpecVersion(SpecVersion ceSpecVersion) {
            this.recipient.setCeSpecVersion(ceSpecVersion);
            return this;
        }

        public Builder<P> ceSource(URI ceSource) {
            this.recipient.setCeSource(ceSource);
            return this;
        }

        public Builder<P> ceEventType(String ceEventType) {
            this.recipient.setCeType(ceEventType);
            return this;
        }

        public Builder<P> ceSubject(String ceSubject) {
            this.recipient.setCeSubject(ceSubject);
            return this;
        }

        public Builder<P> ceDataContentType(String ceDataContentType) {
            this.recipient.setCeDataContentType(ceDataContentType);
            return this;
        }

        public Builder<P> ceDataSchema(URI ceDataSchema) {
            this.recipient.setCeDataSchema(ceDataSchema);
            return this;
        }

        public Builder<P> ceExtension(String name, Object value) {
            this.recipient.addCeExtension(name, value);
            return this;
        }

        public SinkRecipient<P> build() {
            return this.recipient;
        }
    }

    public static class BuilderSelector {
        private BuilderSelector() {
        }

        public Builder<SinkRecipientBinaryPayloadData> forBinaryPayload() {
            return new Builder<SinkRecipientBinaryPayloadData>(new SinkRecipient());
        }

        public Builder<SinkRecipientJsonPayloadData> forJsonPayload() {
            return new Builder<SinkRecipientJsonPayloadData>(new SinkRecipient());
        }
    }

    @Schema(enumeration={"binary", "structured"})
    public static enum ContentMode {
        BINARY("binary"),
        STRUCTURED("structured");

        private final String stringValue;

        private ContentMode(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }

        public static ContentMode parse(String stringValue) {
            switch (stringValue) {
                case "binary": {
                    return BINARY;
                }
                case "structured": {
                    return STRUCTURED;
                }
            }
            throw new IllegalArgumentException("Invalid content mode: " + stringValue);
        }
    }
}

