/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.schedule.timer;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.OffsetDateTime;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;

@Schema(description="Timer schedules establishes that a job must be executed at a given date time and can be repeated a configurable number of times.", allOf={Schedule.class})
@JsonPropertyOrder(value={"startTime", "repeatCount", "delay", "delayUnit"})
public class TimerSchedule
extends Schedule {
    static final String START_TIME_PROPERTY = "startTime";
    static final String REPEAT_COUNT_PROPERTY = "repeatCount";
    static final String DELAY_PROPERTY = "delay";
    static final String DELAY_UNIT_PROPERTY = "delayUnit";
    @Schema(description="Initial fire time for the job in the ISO-8601 standard.", example="2023-01-30T12:01:15+01:00")
    private OffsetDateTime startTime;
    @Schema(description="Number of times that the job execution must be repeated.", defaultValue="0")
    private Integer repeatCount = 0;
    @Schema(description="Time delay between executions.", defaultValue="0")
    private Long delay = 0L;
    private TemporalUnit delayUnit = TemporalUnit.MILLIS;

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public TemporalUnit getDelayUnit() {
        return this.delayUnit;
    }

    public void setDelayUnit(TemporalUnit delayUnit) {
        this.delayUnit = delayUnit;
    }

    public String toString() {
        return "TimerSchedule{startTime='" + this.startTime + "', repeatCount=" + this.repeatCount + ", delay=" + this.delay + ", delayUnit='" + this.delayUnit + "'}";
    }

    public static Builder builder() {
        return new Builder(new TimerSchedule());
    }

    public static class Builder {
        private final TimerSchedule schedule;

        private Builder(TimerSchedule schedule) {
            this.schedule = schedule;
        }

        public Builder startTime(OffsetDateTime startTime) {
            this.schedule.setStartTime(startTime);
            return this;
        }

        public Builder repeatCount(Integer repeatCount) {
            this.schedule.setRepeatCount(repeatCount);
            return this;
        }

        public Builder delay(Long delay) {
            this.schedule.setDelay(delay);
            return this;
        }

        public Builder delayUnit(TemporalUnit delayUnit) {
            this.schedule.setDelayUnit(delayUnit);
            return this;
        }

        public TimerSchedule build() {
            return this.schedule;
        }
    }
}

