/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.serlialization;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.cloudevents.jackson.JsonFormat;
import org.kie.kogito.jobs.service.api.Descriptor;
import org.kie.kogito.jobs.service.api.RecipientDescriptorRegistry;
import org.kie.kogito.jobs.service.api.ScheduleDescriptorRegistry;

public class SerializationUtils {
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = SerializationUtils.buildObjectMapper();

    private SerializationUtils() {
    }

    public static void registerDescriptors(ObjectMapper objectMapper) {
        for (Descriptor descriptor : RecipientDescriptorRegistry.getInstance().getDescriptors()) {
            objectMapper.registerSubtypes(new NamedType[]{new NamedType(descriptor.getType(), descriptor.getName())});
        }
        for (Descriptor descriptor : ScheduleDescriptorRegistry.getInstance().getDescriptors()) {
            objectMapper.registerSubtypes(new NamedType[]{new NamedType(descriptor.getType(), descriptor.getName())});
        }
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)JsonFormat.getCloudEventJacksonModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SerializationUtils.registerDescriptors(objectMapper);
        return objectMapper;
    }
}

