/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.event;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.UUID;
import org.kie.kogito.jobs.service.api.event.JobCloudEvent;

public abstract class AbstractJobCloudEventBuilder<B extends AbstractJobCloudEventBuilder<B, T, E>, T, E extends JobCloudEvent<T>> {
    protected E event;

    protected AbstractJobCloudEventBuilder(E event) {
        this.event = event;
        ((JobCloudEvent)this.event).setSpecVersion(SpecVersion.V1);
        ((JobCloudEvent)this.event).setId(UUID.randomUUID().toString());
        ((JobCloudEvent)this.event).setTime(OffsetDateTime.now());
    }

    public B id(String id) {
        ((JobCloudEvent)this.event).setId(id);
        return this.cast();
    }

    public B source(URI source) {
        ((JobCloudEvent)this.event).setSource(source);
        return this.cast();
    }

    public B type(String type) {
        ((JobCloudEvent)this.event).setType(type);
        return this.cast();
    }

    public B time(OffsetDateTime time) {
        ((JobCloudEvent)this.event).setTime(time);
        return this.cast();
    }

    public B subject(String subject) {
        ((JobCloudEvent)this.event).setSubject(subject);
        return this.cast();
    }

    public B dataContentType(String dataContentType) {
        ((JobCloudEvent)this.event).setDataContentType(dataContentType);
        return this.cast();
    }

    public B dataSchema(URI dataSchema) {
        ((JobCloudEvent)this.event).setDataSchema(dataSchema);
        return this.cast();
    }

    public B data(T data) {
        ((JobCloudEvent)this.event).setData(data);
        return this.cast();
    }

    public B withValuesFrom(CloudEvent cloudEvent) {
        return ((AbstractJobCloudEventBuilder)((AbstractJobCloudEventBuilder)((AbstractJobCloudEventBuilder)((AbstractJobCloudEventBuilder)((AbstractJobCloudEventBuilder)((AbstractJobCloudEventBuilder)this.id(cloudEvent.getId())).source(cloudEvent.getSource())).type(cloudEvent.getType())).time(cloudEvent.getTime() != null ? cloudEvent.getTime() : null)).dataContentType(cloudEvent.getDataContentType())).dataSchema(cloudEvent.getDataSchema() != null ? cloudEvent.getDataSchema() : null)).subject(cloudEvent.getSubject());
    }

    public E build() {
        return this.event;
    }

    protected B cast() {
        return (B)this;
    }
}

