/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.event.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.kie.kogito.jobs.service.api.event.JobCloudEvent;
import org.kie.kogito.jobs.service.api.event.serialization.SerializationException;
import org.kie.kogito.jobs.service.api.serlialization.SerializationUtils;

public class JobCloudEventSerializer {
    private final ObjectMapper objectMapper;

    public JobCloudEventSerializer() {
        this.objectMapper = SerializationUtils.DEFAULT_OBJECT_MAPPER;
    }

    public JobCloudEventSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        SerializationUtils.registerDescriptors(objectMapper);
    }

    public String serialize(JobCloudEvent<?> jobCloudEvent) {
        try {
            return this.objectMapper.writeValueAsString(jobCloudEvent);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("An error was produced during a JobCloudEvent serialization: " + e.getMessage(), e);
        }
    }
}

