/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.recipient.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;

@Schema(description="Recipient definition that executes a http request on a given url and sends the configured \"payload\" as the body.", allOf={Recipient.class}, requiredProperties={"url", "method"})
@JsonPropertyOrder(value={"url", "method", "headers", "queryParams", "payload"})
public class HttpRecipient<T extends HttpRecipientPayloadData<?>>
extends Recipient<T> {
    static final String URL_PROPERTY = "url";
    static final String METHOD_PROPERTY = "method";
    static final String HEADERS_PROPERTY = "headers";
    static final String QUERY_PARAMS_PROPERTY = "queryParams";
    @Schema(description="Url of the recipient that will receive the request.")
    private String url;
    @Schema(description="Http method to use for the request.", defaultValue="POST", enumeration={"POST", "GET", "HEAD", "PUT", "DELETE", "PATCH", "OPTIONS"})
    private String method = "POST";
    @Schema(description="Http headers to send with the request.")
    private Map<String, String> headers = new HashMap<String, String>();
    @Schema(description="Http query parameters to send with the request.")
    private Map<String, String> queryParams = new HashMap<String, String>();
    @JsonProperty(value="payload")
    @Schema(ref="#/components/schemas/HttpRecipientPayloadData")
    private T payload;

    @Override
    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers != null ? headers : new HashMap();
    }

    public HttpRecipient<T> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public String getHeader(String name) {
        return this.headers != null ? this.headers.get(name) : null;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams != null ? queryParams : new HashMap();
    }

    public HttpRecipient<T> addQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public String getQueryParam(String name) {
        return this.queryParams != null ? this.queryParams.get(name) : null;
    }

    public String toString() {
        return "HttpRecipient{url='" + this.url + "', method='" + this.method + "', headers=" + this.headers + ", queryParams=" + this.queryParams + ", payload=" + this.payload + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRecipient recipient = (HttpRecipient)o;
        return Objects.equals(this.url, recipient.url) && Objects.equals(this.method, recipient.method) && Objects.equals(this.headers, recipient.headers) && Objects.equals(this.queryParams, recipient.queryParams) && Objects.equals(this.payload, recipient.payload);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.method, this.headers, this.queryParams, this.payload);
    }

    public static BuilderSelector builder() {
        return new BuilderSelector();
    }

    public static class BuilderSelector {
        private BuilderSelector() {
        }

        public Builder<HttpRecipientStringPayloadData> forStringPayload() {
            return new Builder<HttpRecipientStringPayloadData>(new HttpRecipient());
        }

        public Builder<HttpRecipientBinaryPayloadData> forBinaryPayload() {
            return new Builder<HttpRecipientBinaryPayloadData>(new HttpRecipient());
        }

        public Builder<HttpRecipientJsonPayloadData> forJsonPayload() {
            return new Builder<HttpRecipientJsonPayloadData>(new HttpRecipient());
        }
    }

    public static class Builder<P extends HttpRecipientPayloadData<?>> {
        private final HttpRecipient<P> recipient;

        private Builder(HttpRecipient<P> recipient) {
            this.recipient = recipient;
        }

        public Builder<P> payload(P payload) {
            this.recipient.setPayload(payload);
            return this;
        }

        public Builder<P> url(String url) {
            this.recipient.setUrl(url);
            return this;
        }

        public Builder<P> method(String method) {
            this.recipient.setMethod(method);
            return this;
        }

        public Builder<P> header(String name, String value) {
            this.recipient.addHeader(name, value);
            return this;
        }

        public Builder<P> queryParam(String name, String value) {
            this.recipient.addQueryParam(name, value);
            return this;
        }

        public HttpRecipient<P> build() {
            return this.recipient;
        }
    }
}

