/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.api.schedule.cron;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.kie.kogito.jobs.service.api.Schedule;

@Schema(description="Cron schedules establishes that a job must be executed with a periodicity based on a unix like crontab expression.", allOf={Schedule.class}, requiredProperties={"expression"})
@JsonPropertyOrder(value={"expression", "timeZone"})
public class CronSchedule
extends Schedule {
    static final String EXPRESSION_PROPERTY = "expression";
    static final String TIME_ZONE_PROPERTY = "timeZone";
    @Schema(description="Cron expression for the job execution, for more information <a href=\"https://en.wikipedia.org/wiki/Cron#Overview\" target=\"_blank\">see</a>.")
    private String expression;
    @Schema(description="Time zone for the cron programming, for example \"Europe/Madrid\". For more information <a href=\"https://en.wikipedia.org/wiki/List_of_tz_database_time_zones\" target=\"_blank\">see</a>.")
    private String timeZone;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return "CronSchedule{expression='" + this.expression + "', timeZone='" + this.timeZone + "'}";
    }

    public static Builder builder() {
        return new Builder(new CronSchedule());
    }

    public static class Builder {
        private final CronSchedule schedule;

        private Builder(CronSchedule schedule) {
            this.schedule = schedule;
        }

        public Builder expression(String expression) {
            this.schedule.setExpression(expression);
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.schedule.setTimeZone(timeZone);
            return this;
        }

        public CronSchedule build() {
            return this.schedule;
        }
    }
}

