/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.job;

import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.kie.kogito.jobs.service.exception.JobExecutionException;
import org.kie.kogito.jobs.service.executor.JobExecutorResolver;
import org.kie.kogito.jobs.service.model.JobDetailsContext;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.stream.JobStreams;
import org.kie.kogito.timer.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateJob
implements Job<JobDetailsContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateJob.class);
    private final JobExecutorResolver jobExecutorResolver;
    private final JobStreams jobStreams;

    public DelegateJob(JobExecutorResolver executorResolver, JobStreams jobStreams) {
        this.jobExecutorResolver = executorResolver;
        this.jobStreams = jobStreams;
    }

    public void execute(JobDetailsContext ctx) {
        LOGGER.info("Executing for context {}", (Object)ctx.getJobDetails());
        Optional.ofNullable(ctx).map(JobDetailsContext::getJobDetails).map(arg_0 -> ((JobExecutorResolver)this.jobExecutorResolver).get(arg_0)).map(executor -> executor.execute(ctx.getJobDetails())).orElseThrow(() -> new IllegalStateException("JobDetails cannot be null from context " + ctx)).onItem().invoke(this.jobStreams::publishJobSuccess).onFailure(JobExecutionException.class).invoke(ex -> {
            String jobId = ((JobExecutionException)ex).getJobId();
            LOGGER.error("Error executing job {}", (Object)jobId, ex);
            this.jobStreams.publishJobError(JobExecutionResponse.builder().message(ex.getMessage()).now().jobId(jobId).build());
        }).runSubscriptionOn((Executor)Infrastructure.getDefaultWorkerPool()).subscribe().with(response -> LOGGER.info("Executed successfully with response {}", response));
    }
}

