/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.Objects;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.event.CancelJobRequestEvent;
import org.kie.kogito.jobs.api.event.CreateProcessInstanceJobRequestEvent;
import org.kie.kogito.jobs.api.event.serialization.JobCloudEventDeserializer;
import org.kie.kogito.jobs.service.adapter.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;

public class MessagingConsumer
extends ReactiveMessagingEventConsumer {
    protected JobCloudEventDeserializer deserializer;

    public MessagingConsumer() {
    }

    public MessagingConsumer(TimerDelegateJobScheduler scheduler, ReactiveJobRepository jobRepository, ObjectMapper objectMapper) {
        super(scheduler, jobRepository, "CreateProcessInstanceJobRequest", "CancelJobRequest");
        this.deserializer = new JobCloudEventDeserializer(objectMapper);
    }

    @Override
    public JobDetails getJobDetails(CloudEvent createEvent) {
        if (!Objects.equals(this.getCreateJobEventType(), createEvent.getType())) {
            throw new IllegalArgumentException("Only " + this.getCreateJobEventType() + "is supported to get JobDetails " + createEvent);
        }
        CreateProcessInstanceJobRequestEvent jobCloudEvent = (CreateProcessInstanceJobRequestEvent)this.deserializer.deserialize(createEvent);
        return ScheduledJobAdapter.to((ScheduledJob)ScheduledJob.builder().job((Job)jobCloudEvent.getData()).build());
    }

    @Override
    public String getJobId(CloudEvent createEvent) {
        if (!Objects.equals(this.getCancelJobEventType(), createEvent.getType())) {
            throw new IllegalArgumentException("Only " + this.getCreateJobEventType() + "is supported to get Job Id " + createEvent);
        }
        CancelJobRequestEvent jobCloudEvent = (CancelJobRequestEvent)this.deserializer.deserialize(createEvent);
        return ((CancelJobRequestEvent.JobId)jobCloudEvent.getData()).getId();
    }
}

