/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.Objects;
import org.kie.kogito.jobs.service.adapter.JobDetailsAdapter;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.JobLookupId;
import org.kie.kogito.jobs.service.api.event.CreateJobEvent;
import org.kie.kogito.jobs.service.api.event.DeleteJobEvent;
import org.kie.kogito.jobs.service.api.event.serialization.JobCloudEventDeserializer;
import org.kie.kogito.jobs.service.messaging.ReactiveMessagingEventConsumer;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;

public class MessagingConsumer
extends ReactiveMessagingEventConsumer {
    protected JobCloudEventDeserializer deserializer;

    public MessagingConsumer() {
    }

    public MessagingConsumer(TimerDelegateJobScheduler scheduler, ReactiveJobRepository jobRepository, ObjectMapper objectMapper) {
        super(scheduler, jobRepository, "job.create", "job.delete");
        this.deserializer = new JobCloudEventDeserializer(objectMapper);
    }

    @Override
    public JobDetails getJobDetails(CloudEvent createEvent) {
        if (!Objects.equals(this.getCreateJobEventType(), createEvent.getType())) {
            throw new IllegalArgumentException("Only " + this.getCreateJobEventType() + "is supported to get JobDetails " + createEvent);
        }
        CreateJobEvent jobCloudEvent = (CreateJobEvent)this.deserializer.deserialize(createEvent);
        return JobDetailsAdapter.from((Job)((Job)jobCloudEvent.getData()));
    }

    @Override
    public String getJobId(CloudEvent createEvent) {
        if (!Objects.equals(this.getCancelJobEventType(), createEvent.getType())) {
            throw new IllegalArgumentException("Only " + this.getCreateJobEventType() + "is supported to get Job Id " + createEvent);
        }
        DeleteJobEvent jobCloudEvent = (DeleteJobEvent)this.deserializer.deserialize(createEvent);
        return ((JobLookupId)jobCloudEvent.getData()).getId();
    }
}

