/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.impl;

import io.vertx.core.Vertx;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.stream.JobStreams;

public abstract class BaseReactiveJobRepository
implements ReactiveJobRepository {
    private Vertx vertx;
    private JobStreams jobStreams;

    protected BaseReactiveJobRepository(Vertx vertx, JobStreams jobStreams) {
        this.vertx = vertx;
        this.jobStreams = jobStreams;
    }

    public <T> CompletionStage<T> runAsync(Supplier<T> function) {
        CompletableFuture future = new CompletableFuture();
        this.vertx.executeBlocking(v -> future.complete(function.get()), r -> {});
        return future;
    }

    @Override
    public PublisherBuilder<JobDetails> findByStatus(JobStatus ... status) {
        return this.findAll().filter(job -> Objects.nonNull(job.getStatus())).filter(job -> Arrays.stream(status).anyMatch(arg_0 -> job.getStatus().equals(arg_0)));
    }

    @Override
    public CompletionStage<JobDetails> save(JobDetails job) {
        return this.doSave(job).thenApply(this.jobStreams::publishJobStatusChange);
    }

    public abstract CompletionStage<JobDetails> doSave(JobDetails var1);

    @Override
    public CompletionStage<JobDetails> delete(JobDetails job) {
        return this.delete(job.getId()).thenApply(j -> this.jobStreams.publishJobStatusChange(job));
    }

    @Override
    public CompletionStage<JobDetails> merge(String id, JobDetails jobToMerge) {
        return Optional.ofNullable(id).filter(StringUtils::isNotBlank).filter(s -> StringUtils.isBlank((CharSequence)jobToMerge.getId()) || s.equals(jobToMerge.getId())).map(jobId -> this.get((String)jobId).thenApply(Optional::ofNullable).thenApply(j -> j.map(currentJob -> this.doMerge(jobToMerge, (JobDetails)currentJob))).thenCompose(j -> j.map(this::save).orElse(CompletableFuture.completedFuture(null)))).orElseThrow(() -> new IllegalArgumentException("Id is empty or not equals to Job.id : " + id));
    }

    private JobDetails doMerge(JobDetails toMerge, JobDetails current) {
        return JobDetails.builder().of(current).merge(toMerge).build();
    }
}

