/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.marshaller;

import io.quarkus.arc.DefaultBean;
import io.vertx.core.json.JsonObject;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.repository.marshaller.Marshaller;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.TriggerMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;

@DefaultBean
@ApplicationScoped
public class JobDetailsMarshaller
implements Marshaller<JobDetails, JsonObject> {
    RecipientMarshaller recipientMarshaller;
    TriggerMarshaller triggerMarshaller;

    public JobDetailsMarshaller() {
    }

    @Inject
    public JobDetailsMarshaller(TriggerMarshaller triggerMarshaller, RecipientMarshaller recipientMarshaller) {
        this.recipientMarshaller = recipientMarshaller;
        this.triggerMarshaller = triggerMarshaller;
    }

    @Override
    public JsonObject marshall(JobDetails jobDetails) {
        if (jobDetails != null) {
            return JsonObject.mapFrom((Object)new JobDetailsAccessor(jobDetails, this.recipientMarshaller, this.triggerMarshaller));
        }
        return null;
    }

    @Override
    public JobDetails unmarshall(JsonObject jsonObject) {
        if (jsonObject != null) {
            return ((JobDetailsAccessor)jsonObject.mapTo(JobDetailsAccessor.class)).to(this.recipientMarshaller, this.triggerMarshaller);
        }
        return null;
    }

    private static class JobDetailsAccessor {
        private String id;
        private String correlationId;
        private String status;
        private Date lastUpdate;
        private Integer retries;
        private Integer priority;
        private Integer executionCounter;
        private String scheduledId;
        private Map<String, Object> recipient;
        private Map<String, Object> trigger;
        private Long executionTimeout;
        private String executionTimeoutUnit;

        public JobDetailsAccessor() {
        }

        public JobDetailsAccessor(JobDetails jobDetails, RecipientMarshaller recipientMarshaller, TriggerMarshaller triggerMarshaller) {
            this.id = jobDetails.getId();
            this.correlationId = jobDetails.getCorrelationId();
            this.status = Optional.ofNullable(jobDetails.getStatus()).map(Enum::name).orElse(null);
            this.lastUpdate = Optional.ofNullable(jobDetails.getLastUpdate()).map(u -> Date.from(u.toInstant())).orElse(null);
            this.retries = jobDetails.getRetries();
            this.priority = jobDetails.getPriority();
            this.executionCounter = jobDetails.getExecutionCounter();
            this.scheduledId = jobDetails.getScheduledId();
            this.recipient = Optional.ofNullable(jobDetails.getRecipient()).map(r -> recipientMarshaller.marshall((Recipient)r).getMap()).orElse(null);
            this.trigger = Optional.ofNullable(jobDetails.getTrigger()).map(t -> triggerMarshaller.marshall((Trigger)t).getMap()).orElse(null);
            this.executionTimeout = jobDetails.getExecutionTimeout();
            this.executionTimeoutUnit = Optional.ofNullable(jobDetails.getExecutionTimeoutUnit()).map(Enum::name).orElse(null);
        }

        public JobDetails to(RecipientMarshaller recipientMarshaller, TriggerMarshaller triggerMarshaller) {
            return JobDetails.builder().id(this.id).correlationId(this.correlationId).status((JobStatus)Optional.ofNullable(this.status).map(JobStatus::valueOf).orElse(null)).lastUpdate((ZonedDateTime)Optional.ofNullable(this.lastUpdate).map(t -> ZonedDateTime.ofInstant(t.toInstant(), DateUtil.DEFAULT_ZONE)).orElse(null)).retries(this.retries).executionCounter(this.executionCounter).scheduledId(this.scheduledId).priority(this.priority).recipient((Recipient)Optional.ofNullable(this.recipient).map(r -> recipientMarshaller.unmarshall(new JsonObject(r))).orElse(null)).trigger((Trigger)Optional.ofNullable(this.trigger).map(t -> triggerMarshaller.unmarshall(new JsonObject(t))).orElse(null)).executionTimeout(this.executionTimeout).executionTimeoutUnit((ChronoUnit)Optional.ofNullable(this.executionTimeoutUnit).map(ChronoUnit::valueOf).orElse(null)).build();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(String correlationId) {
            this.correlationId = correlationId;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Date getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(Date lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public Integer getExecutionCounter() {
            return this.executionCounter;
        }

        public void setExecutionCounter(Integer executionCounter) {
            this.executionCounter = executionCounter;
        }

        public String getScheduledId() {
            return this.scheduledId;
        }

        public void setScheduledId(String scheduledId) {
            this.scheduledId = scheduledId;
        }

        public Map<String, Object> getRecipient() {
            return this.recipient;
        }

        public void setRecipient(Map<String, Object> recipient) {
            this.recipient = recipient;
        }

        public Map<String, Object> getTrigger() {
            return this.trigger;
        }

        public void setTrigger(Map<String, Object> trigger) {
            this.trigger = trigger;
        }

        public Long getExecutionTimeout() {
            return this.executionTimeout;
        }

        public void setExecutionTimeout(Long executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        public String getExecutionTimeoutUnit() {
            return this.executionTimeoutUnit;
        }

        public void setExecutionTimeoutUnit(String executionTimeoutUnit) {
            this.executionTimeoutUnit = executionTimeoutUnit;
        }
    }
}

