/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2;

import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.kie.kogito.jobs.service.adapter.JobDetailsAdapter;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.kie.kogito.jobs.service.validation.JobValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="/v2/jobs")
public class JobResourceV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobResourceV2.class);
    @Inject
    TimerDelegateJobScheduler scheduler;
    @Inject
    ReactiveJobRepository jobRepository;
    @Inject
    JobValidator jobValidator;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(operationId="createJobV2")
    public Uni<Job> create(Job job) {
        LOGGER.debug("REST create {}", (Object)job);
        this.jobValidator.validateToCreate(job);
        JobDetails jobDetails = JobDetailsAdapter.from((Job)job);
        return Uni.createFrom().publisher(this.scheduler.schedule(jobDetails)).onItem().ifNull().failWith((Throwable)new RuntimeException("Failed to schedule job " + job)).onItem().transform(JobDetailsAdapter::toJob);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(operationId="deleteJobV2")
    public Uni<Job> delete(@PathParam(value="id") String id) {
        return Uni.createFrom().completionStage((CompletionStage)this.scheduler.cancel(id)).onItem().ifNull().failWith((Throwable)new NotFoundException("Failed to cancel job scheduling for jobId " + id)).onItem().transform(JobDetailsAdapter::toJob);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(operationId="getJobV2")
    public Uni<Job> get(@PathParam(value="id") String id) {
        return Uni.createFrom().completionStage(this.jobRepository.get(id)).onItem().ifNull().failWith((Throwable)new NotFoundException("Job not found id " + id)).onItem().transform(JobDetailsAdapter::toJob);
    }
}

