/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.vertx.core.Vertx;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.qualifier.Repository;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.repository.impl.BaseReactiveJobRepository;
import org.kie.kogito.jobs.service.stream.JobStreams;
import org.kie.kogito.jobs.service.utils.DateUtil;

@ApplicationScoped
@Repository(value="infinispan")
public class InfinispanJobRepository
extends BaseReactiveJobRepository
implements ReactiveJobRepository {
    private RemoteCache<String, ScheduledJob> cache;
    private QueryFactory queryFactory;

    InfinispanJobRepository() {
        super(null, null);
    }

    @Inject
    public InfinispanJobRepository(Vertx vertx, JobStreams jobStreams, RemoteCacheManager remoteCacheManager) {
        super(vertx, jobStreams);
        this.cache = remoteCacheManager.administration().getOrCreateCache("SCHEDULED_JOBS", (String)null);
        this.queryFactory = Search.getQueryFactory(this.cache);
    }

    @Override
    public CompletionStage<ScheduledJob> doSave(ScheduledJob job) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.put((Object)job.getId(), (Object)job)))).thenCompose(j -> this.get(job.getId()));
    }

    @Override
    public CompletionStage<ScheduledJob> get(String id) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.get((Object)id))));
    }

    @Override
    public CompletionStage<Boolean> exists(String id) {
        return this.runAsync(() -> this.cache.containsKey((Object)id));
    }

    @Override
    public CompletionStage<ScheduledJob> delete(String id) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)id))));
    }

    @Override
    public PublisherBuilder<ScheduledJob> findAll() {
        return ReactiveStreams.fromIterable((Iterable)this.queryFactory.from(ScheduledJob.class).build().list());
    }

    @Override
    public PublisherBuilder<ScheduledJob> findByStatus(JobStatus ... status) {
        return ReactiveStreams.fromIterable((Iterable)this.queryFactory.from(ScheduledJob.class).having("status").in((Collection)Arrays.stream(status).map(Enum::name).collect(Collectors.toList())).build().list());
    }

    @Override
    public PublisherBuilder<ScheduledJob> findByStatusBetweenDatesOrderByPriority(ZonedDateTime from, ZonedDateTime to, JobStatus ... status) {
        return ReactiveStreams.fromIterable((Iterable)this.queryFactory.from(ScheduledJob.class).having("status").in((Collection)Arrays.stream(status).map(Enum::name).collect(Collectors.toList())).and().having("expirationTime").between((Object)DateUtil.zonedDateTimeToInstant(from), (Object)DateUtil.zonedDateTimeToInstant(to)).orderBy("priority", SortOrder.DESC).build().list());
    }
}

