/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.VertxJobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="/jobs")
public class JobResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobResource.class);
    public static final String JOBS_PATH = "/jobs";
    @Inject
    VertxJobScheduler scheduler;
    @Inject
    ReactiveJobRepository jobRepository;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CompletionStage<ScheduledJob> create(Job job) {
        LOGGER.debug("REST create {}", (Object)job);
        return ReactiveStreams.fromPublisher(this.scheduler.schedule(job)).findFirst().run().thenApply(j -> (ScheduledJob)((Object)((Object)j.orElseThrow(() -> new RuntimeException("Failed to schedule job " + job)))));
    }

    @PATCH
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CompletionStage<ScheduledJob> patch(@PathParam(value="id") String id, @RequestBody Job job) {
        LOGGER.debug("REST patch update {}", (Object)job);
        return this.jobRepository.merge(id, ScheduledJob.ScheduledJobBuilder.from(job)).thenApply(result -> Optional.ofNullable(result).orElseThrow(() -> new NotFoundException("Job not found " + job)));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public CompletionStage<ScheduledJob> delete(@PathParam(value="id") String id) {
        LOGGER.debug("REST delete id {}", (Object)id);
        return this.scheduler.cancel(id).thenApply(result -> Optional.ofNullable(result).orElseThrow(() -> new NotFoundException("Failed to cancel job scheduling for jobId " + id)));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public CompletionStage<ScheduledJob> get(@PathParam(value="id") String id) {
        LOGGER.debug("REST get {}", (Object)id);
        return this.jobRepository.get(id).thenApply(result -> Optional.ofNullable(result).orElseThrow(() -> new NotFoundException("Job not found id " + id)));
    }
}

