/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler.impl;

import io.vertx.axle.core.Vertx;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.executor.JobExecutor;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.BaseTimerJobScheduler;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VertxJobScheduler
extends BaseTimerJobScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxJobScheduler.class);
    @Inject
    Vertx vertx;

    protected VertxJobScheduler() {
    }

    public VertxJobScheduler(Vertx vertx, JobExecutor jobExecutor, ReactiveJobRepository jobRepository, long backoffRetryMillis, long maxIntervalLimitToRetryMillis) {
        super(jobExecutor, jobRepository, backoffRetryMillis, maxIntervalLimitToRetryMillis);
        this.vertx = vertx;
    }

    @Override
    public PublisherBuilder<String> doSchedule(Duration delay, Job job) {
        LOGGER.debug("Job Scheduling {}", (Object)job);
        return ReactiveStreams.of((Object)job).map(j -> this.setTimer(delay, (Job)j)).map(String::valueOf);
    }

    @Override
    public PublisherBuilder<String> doPeriodicSchedule(Duration interval, Job job) {
        LOGGER.debug("Job Periodic Scheduling {}", (Object)job);
        return ReactiveStreams.of((Object)job).map(j -> this.setPeriodicTimer(interval, (Job)j)).map(String::valueOf);
    }

    private long setTimer(Duration delay, Job job) {
        return this.vertx.setTimer(delay.toMillis(), scheduledId -> this.execute(job));
    }

    private long setPeriodicTimer(Duration interval, Job job) {
        return this.vertx.setPeriodic(interval.toMillis(), scheduledId -> this.execute(job));
    }

    @Override
    public Publisher<Boolean> doCancel(ScheduledJob scheduledJob) {
        return ReactiveStreams.of((Object)((Object)scheduledJob)).map(ScheduledJob::getScheduledId).filter(Objects::nonNull).map(Long::valueOf).map(arg_0 -> ((Vertx)this.vertx).cancelTimer(arg_0)).buildRs();
    }

    @Incoming(value="job-error-events")
    public CompletionStage jobErrorProcessor(JobExecutionResponse error) {
        LOGGER.warn("Error received {}", (Object)error);
        return this.handleJobExecutionError(error).findFirst().run();
    }

    @Incoming(value="job-success-events")
    public CompletionStage jobSuccessProcessor(JobExecutionResponse response) {
        LOGGER.debug("Success received to be processed {}", (Object)response);
        return this.handleJobExecutionSuccess(response).findFirst().run();
    }
}

