/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.runtime.StartupEvent;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=0)
@Singleton
public class InfinispanConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanConfiguration.class);
    public static final String PERSISTENCE_CONFIG_KEY = "kogito.jobs-service.persistence";
    private Optional<RemoteCacheManager> cacheManager;

    @Inject
    public InfinispanConfiguration(Instance<RemoteCacheManager> cacheManagerInstance, @ConfigProperty(name="kogito.jobs-service.persistence") Optional<String> persistence) {
        LOGGER.info("Persistence config {}", persistence);
        this.cacheManager = persistence.filter("infinispan"::equals).map(p -> (RemoteCacheManager)cacheManagerInstance.get());
    }

    CompletionStage<Void> onStart(@Observes StartupEvent startupEvent) {
        return ReactiveStreams.of((Object[])Caches.all()).forEach(name -> this.cacheManager.map(RemoteCacheManager::administration).ifPresent(adm -> adm.getOrCreateCache(name, (String)null))).run().thenAccept(c -> LOGGER.info("Executed Infinispan configuration"));
    }

    public static class Caches {
        public static final String SCHEDULED_JOBS = "SCHEDULED_JOBS";

        private Caches() {
        }

        public static String[] all() {
            return new String[]{SCHEDULED_JOBS};
        }
    }
}

