/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.infinispan.client.Remote;
import io.vertx.core.Vertx;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.qualifier.Repository;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.repository.impl.BaseReactiveJobRepository;
import org.kie.kogito.jobs.service.stream.JobStreams;

@ApplicationScoped
@Repository(value="infinispan")
public class InfinispanJobRepository
extends BaseReactiveJobRepository
implements ReactiveJobRepository {
    private RemoteCache<String, ScheduledJob> cache;
    private QueryFactory queryFactory;

    InfinispanJobRepository() {
        super(null, null);
    }

    @Inject
    public InfinispanJobRepository(Vertx vertx, JobStreams jobStreams, @Remote(value="SCHEDULED_JOBS") RemoteCache<String, ScheduledJob> cache) {
        super(vertx, jobStreams);
        this.cache = cache;
        this.queryFactory = Search.getQueryFactory(cache);
    }

    @Override
    public CompletionStage<ScheduledJob> doSave(ScheduledJob job) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.put((Object)job.getId(), (Object)job)))).thenCompose(j -> this.get(job.getId()));
    }

    @Override
    public CompletionStage<ScheduledJob> get(String id) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.get((Object)id))));
    }

    @Override
    public CompletionStage<Boolean> exists(String id) {
        return this.runAsync(() -> this.cache.containsKey((Object)id));
    }

    @Override
    public CompletionStage<ScheduledJob> delete(String id) {
        return this.runAsync(() -> (ScheduledJob)((Object)((Object)this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)id))));
    }

    @Override
    public PublisherBuilder<ScheduledJob> findAll() {
        return ReactiveStreams.fromIterable((Iterable)Optional.ofNullable(this.cache).map(RemoteCache::values).orElse(Collections.emptyList()));
    }

    @Override
    public PublisherBuilder<ScheduledJob> findByStatus(JobStatus ... status) {
        return ReactiveStreams.fromIterable((Iterable)((QueryBuilder)this.queryFactory.from(ScheduledJob.class).having("status").in((Collection)Arrays.stream(status).map(Enum::name).collect(Collectors.toList())).maxResults(50000)).build().list());
    }
}

