/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler;

import io.quarkus.runtime.StartupEvent;
import java.util.concurrent.CompletionStage;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.VertxJobScheduler;
import org.kie.kogito.jobs.service.utils.ErrorHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobSchedulerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerManager.class);
    @Inject
    VertxJobScheduler scheduler;
    @Inject
    ReactiveJobRepository repository;

    CompletionStage<Void> loadScheduledJobs(@Observes StartupEvent startupEvent) {
        LOGGER.info("Loading scheduled jobs");
        return this.repository.findByStatus(JobStatus.SCHEDULED, JobStatus.RETRY).flatMapRsPublisher(t -> ErrorHandling.skipErrorPublisher(this.scheduler::schedule, t)).onError(ex -> LOGGER.error("Error loading jobs", ex)).forEach(a -> LOGGER.info("Loaded and scheduled job {}", (Object)a)).run().thenAccept(c -> LOGGER.info("Loading scheduled jobs completed !"));
    }
}

