/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.scheduler.impl.TimerDelegateJobScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="/jobs")
public class JobResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobResource.class);
    public static final String JOBS_PATH = "/jobs";
    @Inject
    TimerDelegateJobScheduler scheduler;
    @Inject
    ReactiveJobRepository jobRepository;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CompletionStage<ScheduledJob> create(Job job) {
        LOGGER.debug("REST create {}", (Object)job);
        return ReactiveStreams.fromPublisher(this.scheduler.schedule(ScheduledJobAdapter.to(ScheduledJob.builder().job(job).build()))).map(ScheduledJobAdapter::of).findFirst().run().thenApply(j -> (ScheduledJob)((Object)((Object)j.orElseThrow(() -> new RuntimeException("Failed to schedule job " + job)))));
    }

    @PATCH
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CompletionStage<ScheduledJob> patch(@PathParam(value="id") String id, @RequestBody Job job) {
        LOGGER.debug("REST patch update {}", (Object)job);
        JobDetails jobToBeMerged = ScheduledJobAdapter.to(ScheduledJob.ScheduledJobBuilder.from(job));
        if (Objects.nonNull(jobToBeMerged.getPayload()) || StringUtils.isNotEmpty((CharSequence)jobToBeMerged.getId()) || StringUtils.isNotEmpty((CharSequence)jobToBeMerged.getScheduledId()) || StringUtils.isNotEmpty((CharSequence)jobToBeMerged.getCorrelationId()) || Objects.nonNull(jobToBeMerged.getExecutionCounter()) && jobToBeMerged.getExecutionCounter() > 0 || Objects.nonNull(jobToBeMerged.getPriority()) || Objects.nonNull(jobToBeMerged.getRetries()) && jobToBeMerged.getRetries() > 0 || Objects.nonNull(jobToBeMerged.getRecipient()) || Objects.nonNull((Object)jobToBeMerged.getStatus())) {
            throw new IllegalArgumentException("Patch an only be applied to the Job scheduling trigger attributes");
        }
        return this.scheduler.reschedule(id, jobToBeMerged.getTrigger()).map(ScheduledJobAdapter::of).findFirst().run().thenApply(j -> (ScheduledJob)((Object)((Object)j.orElseThrow(() -> new NotFoundException("Failed to reschedule job " + job)))));
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public CompletionStage<ScheduledJob> delete(@PathParam(value="id") String id) {
        LOGGER.debug("REST delete id {}", (Object)id);
        return this.scheduler.cancel(id).thenApply(result -> Optional.ofNullable(result).map(ScheduledJobAdapter::of).orElseThrow(() -> new NotFoundException("Failed to cancel job scheduling for jobId " + id)));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public CompletionStage<ScheduledJob> get(@PathParam(value="id") String id) {
        LOGGER.debug("REST get {}", (Object)id);
        return this.jobRepository.get(id).thenApply(result -> Optional.ofNullable(result).map(ScheduledJobAdapter::of).orElseThrow(() -> new NotFoundException("Job not found id " + id)));
    }
}

