/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Materialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistenceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistenceUtils.class);
    private static final String TOPIC = "kogito.process.%s";
    private static final String STORE = "kogito-%s-store";

    private KafkaPersistenceUtils() {
    }

    public static String topicName(String processId) {
        return String.format(TOPIC, processId);
    }

    public static String storeName(String processId) {
        return String.format(STORE, processId);
    }

    public static Topology createTopologyForProcesses(List<String> processes) {
        StreamsBuilder builder = new StreamsBuilder();
        processes.forEach(p -> {
            builder.globalTable(KafkaPersistenceUtils.topicName(p), Materialized.as((String)KafkaPersistenceUtils.storeName(p)).withKeySerde(Serdes.String()).withValueSerde(Serdes.ByteArray()));
            LOGGER.info("Created Kafka Stream GlobalTable for process {}", p);
        });
        return builder.build();
    }
}

