/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.events.knative.ce.http.ExtMediaType;
import org.kie.kogito.events.knative.ce.http.ResponseError;

@QuarkusTest
class CloudEventListenerResourceTest {
    private final EventFormat formatter = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    CloudEventListenerResourceTest() {
    }

    @Test
    void verifyHttpRequestIsNotACloudEvent() {
        ResponseError error = (ResponseError)((Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("Whatever non-sense").header("Content-Type", (Object)"text/plain", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.BAD_REQUEST.getStatusCode())).extract().response()).as(ResponseError.class);
        Assertions.assertThat((String)error.getCause()).contains(new CharSequence[]{"Failed to parse CloudEvent"});
    }

    @Test
    void verifyHttpRequestWithTextPayloadExpectsString() {
        String source = "/from/unit/test";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("Ciao!").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"text/plain", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).body(Matchers.containsString((String)"kogitoreferenceid"), new Matcher[0])).body(Matchers.containsString((String)"text/plain"), new Matcher[0]);
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsString() {
        String source = "/from/unit/test";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).body(Matchers.containsString((String)"kogitoreferenceid"), new Matcher[0]);
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsPOJO() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        CloudEvent event = this.formatter.deserialize(((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).extract().body().asByteArray());
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((URI)event.getSource()).isEqualTo((Object)new URI("/from/unit/test"));
        Assertions.assertThat((byte[])event.getData()).isNotEmpty();
        Assertions.assertThat((String)((Message)new ObjectMapper().readValue(event.getData(), Message.class)).getMessage()).isEqualTo("Hola Mundo!");
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsPOJO() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        CloudEvent event = this.formatter.deserialize(((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"kogitoReferenceId\":\"12345!\", \"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType(ExtMediaType.CLOUDEVENTS_JSON_TYPE.withCharset(StandardCharsets.UTF_8.name()).toString()).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).extract().body().asByteArray());
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((URI)event.getSource()).isEqualTo((Object)new URI("/from/unit/test"));
        Assertions.assertThat((byte[])event.getData()).isNotEmpty();
        ObjectMapper mapper = new ObjectMapper();
        Assertions.assertThat((String)((Message)mapper.readValue(event.getData(), Message.class)).getMessage()).isEqualTo("Hi World!");
        Assertions.assertThat((Iterable)event.getExtensionNames()).isNotEmpty();
        Assertions.assertThat((Object)event.getExtension("kogitoReferenceId")).isEqualTo((Object)"12345!");
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsString() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        CloudEvent event = this.formatter.deserialize(((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType("application/cloudevents+json").post("", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).extract().body().asByteArray());
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((URI)event.getSource()).isEqualTo((Object)new URI("/from/unit/test"));
        Assertions.assertThat((byte[])event.getData()).isNotEmpty();
        Assertions.assertThat((String)((Message)new ObjectMapper().readValue(event.getData(), Message.class)).getMessage()).isEqualTo("Hi World!");
    }

    public static class Message {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

