/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloudevents.extension;

import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.cloudevents.extension.KogitoExtensionUtils;

public class KogitoExtension
implements CloudEventExtension {
    public static final String KOGITO_EXECUTION_ID = "kogitoexecutionid";
    public static final String KOGITO_DMN_MODEL_NAME = "kogitodmnmodelname";
    public static final String KOGITO_DMN_MODEL_NAMESPACE = "kogitodmnmodelnamespace";
    public static final String KOGITO_DMN_EVALUATE_DECISION = "kogitodmnevaldecision";
    public static final String KOGITO_DMN_FULL_RESULT = "kogitodmnfullresult";
    public static final String KOGITO_DMN_FILTERED_CTX = "kogitodmnfilteredctx";
    private static final Set<String> KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("kogitoexecutionid", "kogitodmnmodelname", "kogitodmnmodelnamespace", "kogitodmnevaldecision", "kogitodmnfullresult", "kogitodmnfilteredctx")));
    private String executionId;
    private String dmnModelName;
    private String dmnModelNamespace;
    private String dmnEvaluateDecision;
    private Boolean dmnFullResult;
    private Boolean dmnFilteredCtx;

    public static void register() {
        ExtensionProvider.getInstance().registerExtension(KogitoExtension.class, KogitoExtension::new);
    }

    public void readFrom(CloudEventExtensions extensions) {
        KogitoExtensionUtils.readStringExtension(extensions, KOGITO_EXECUTION_ID, this::setExecutionId);
        KogitoExtensionUtils.readStringExtension(extensions, KOGITO_DMN_MODEL_NAME, this::setDmnModelName);
        KogitoExtensionUtils.readStringExtension(extensions, KOGITO_DMN_MODEL_NAMESPACE, this::setDmnModelNamespace);
        KogitoExtensionUtils.readStringExtension(extensions, KOGITO_DMN_EVALUATE_DECISION, this::setDmnEvaluateDecision);
        KogitoExtensionUtils.readBooleanExtension(extensions, KOGITO_DMN_FULL_RESULT, this::setDmnFullResult);
        KogitoExtensionUtils.readBooleanExtension(extensions, KOGITO_DMN_FILTERED_CTX, this::setDmnFilteredCtx);
    }

    public Object getValue(String key) throws IllegalArgumentException {
        switch (key) {
            case "kogitoexecutionid": {
                return this.getExecutionId();
            }
            case "kogitodmnmodelname": {
                return this.getDmnModelName();
            }
            case "kogitodmnmodelnamespace": {
                return this.getDmnModelNamespace();
            }
            case "kogitodmnevaldecision": {
                return this.getDmnEvaluateDecision();
            }
            case "kogitodmnfullresult": {
                return this.isDmnFullResult();
            }
            case "kogitodmnfilteredctx": {
                return this.isDmnFilteredCtx();
            }
        }
        return null;
    }

    public Set<String> getKeys() {
        return KEYS;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getDmnModelName() {
        return this.dmnModelName;
    }

    public void setDmnModelName(String dmnModelName) {
        this.dmnModelName = dmnModelName;
    }

    public String getDmnModelNamespace() {
        return this.dmnModelNamespace;
    }

    public void setDmnModelNamespace(String dmnModelNamespace) {
        this.dmnModelNamespace = dmnModelNamespace;
    }

    public String getDmnEvaluateDecision() {
        return this.dmnEvaluateDecision;
    }

    public void setDmnEvaluateDecision(String dmnEvaluateDecision) {
        this.dmnEvaluateDecision = dmnEvaluateDecision;
    }

    public Boolean isDmnFullResult() {
        return this.dmnFullResult;
    }

    public void setDmnFullResult(Boolean dmnFullResult) {
        this.dmnFullResult = dmnFullResult;
    }

    public Boolean isDmnFilteredCtx() {
        return this.dmnFilteredCtx;
    }

    public void setDmnFilteredCtx(Boolean dmnFilteredCtx) {
        this.dmnFilteredCtx = dmnFilteredCtx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KogitoExtension that = (KogitoExtension)o;
        return Objects.equals(this.executionId, that.executionId) && Objects.equals(this.dmnModelName, that.dmnModelName) && Objects.equals(this.dmnModelNamespace, that.dmnModelNamespace) && Objects.equals(this.dmnEvaluateDecision, that.dmnEvaluateDecision) && Objects.equals(this.dmnFullResult, that.dmnFullResult) && Objects.equals(this.dmnFilteredCtx, that.dmnFilteredCtx);
    }

    public int hashCode() {
        return Objects.hash(this.executionId, this.dmnModelName, this.dmnModelNamespace, this.dmnEvaluateDecision, this.dmnFullResult, this.dmnFilteredCtx);
    }

    public String toString() {
        return "KogitoExtension{executionId='" + this.executionId + "', dmnModelName='" + this.dmnModelName + "', dmnModelNamespace='" + this.dmnModelNamespace + "', dmnEvaluateDecision='" + this.dmnEvaluateDecision + "', dmnFullResult=" + this.dmnFullResult + ", dmnFilteredCtx=" + this.dmnFilteredCtx + "}";
    }
}

