/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb.codec;

import java.util.stream.Collectors;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.events.mongodb.codec.CodecUtils;

public class ProcessInstanceDataEventCodec
implements CollectibleCodec<ProcessInstanceDataEvent> {
    public ProcessInstanceDataEvent generateIdIfAbsentFromDocument(ProcessInstanceDataEvent processInstanceDataEvent) {
        return processInstanceDataEvent;
    }

    public boolean documentHasId(ProcessInstanceDataEvent processInstanceDataEvent) {
        return processInstanceDataEvent.getId() != null;
    }

    public BsonValue getDocumentId(ProcessInstanceDataEvent processInstanceDataEvent) {
        return new BsonString(processInstanceDataEvent.getId());
    }

    public ProcessInstanceDataEvent decode(BsonReader bsonReader, DecoderContext decoderContext) {
        return null;
    }

    public void encode(BsonWriter bsonWriter, ProcessInstanceDataEvent processInstanceDataEvent, EncoderContext encoderContext) {
        Document doc = new Document();
        CodecUtils.encodeDataEvent(doc, processInstanceDataEvent);
        doc.put("kogitoParentProcessinstanceId", (Object)processInstanceDataEvent.getKogitoParentProcessinstanceId());
        doc.put("kogitoProcessinstanceState", (Object)processInstanceDataEvent.getKogitoProcessinstanceState());
        doc.put("kogitoReferenceId", (Object)processInstanceDataEvent.getKogitoReferenceId());
        doc.put("kogitoStartFromNode", (Object)processInstanceDataEvent.getKogitoStartFromNode());
        doc.put("data", (Object)this.encodeData((ProcessInstanceEventBody)processInstanceDataEvent.getData()));
        CodecUtils.codec().encode(bsonWriter, (Object)doc, encoderContext);
    }

    private Document encodeData(ProcessInstanceEventBody data) {
        Document doc = new Document();
        doc.put("id", (Object)data.getId());
        doc.put("parentInstanceId", (Object)data.getParentInstanceId());
        doc.put("rootInstanceId", (Object)data.getRootInstanceId());
        doc.put("processId", (Object)data.getProcessId());
        doc.put("rootProcessId", (Object)data.getRootProcessId());
        doc.put("processName", (Object)data.getProcessName());
        doc.put("startDate", (Object)data.getStartDate());
        doc.put("endDate", (Object)data.getEndDate());
        doc.put("state", (Object)data.getState());
        doc.put("businessKey", (Object)data.getBusinessKey());
        doc.put("roles", (Object)data.getRoles());
        if (data.getVariables() != null) {
            doc.put("variables", (Object)new Document(data.getVariables()));
        }
        if (data.getNodeInstances() != null) {
            doc.put("nodeInstances", data.getNodeInstances().stream().map(ni -> {
                Document niDoc = new Document();
                niDoc.put("id", (Object)ni.getId());
                niDoc.put("nodeId", (Object)ni.getNodeId());
                niDoc.put("nodeDefinitionId", (Object)ni.getNodeDefinitionId());
                niDoc.put("nodeName", (Object)ni.getNodeName());
                niDoc.put("nodeType", (Object)ni.getNodeType());
                niDoc.put("triggerTime", (Object)ni.getTriggerTime());
                if (ni.getLeaveTime() != null) {
                    niDoc.put("leaveTime", (Object)ni.getLeaveTime());
                }
                return niDoc;
            }).collect(Collectors.toSet()));
        }
        if (data.getError() != null) {
            Document eDoc = new Document();
            eDoc.put("errorMessage", (Object)data.getError().getErrorMessage());
            eDoc.put("nodeDefinitionId", (Object)data.getError().getNodeDefinitionId());
            doc.put("error", (Object)eDoc);
        }
        if (data.getMilestones() != null) {
            doc.put("milestones", data.getMilestones().stream().map(m -> {
                Document mDoc = new Document();
                mDoc.put("id", (Object)m.getId());
                mDoc.put("name", (Object)m.getName());
                mDoc.put("status", (Object)m.getStatus());
                return mDoc;
            }).collect(Collectors.toSet()));
        }
        return doc;
    }

    public Class<ProcessInstanceDataEvent> getEncoderClass() {
        return ProcessInstanceDataEvent.class;
    }
}

