/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;

public class URIBuilder {
    private URIBuilder() {
    }

    public static URI toURI(String urlStr) {
        try {
            URL url = new URL(urlStr);
            Integer port = Optional.of(url.getPort()).filter(p -> !p.equals(-1)).orElse(url.getDefaultPort());
            URI uri = url.toURI();
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Not valid URI: " + urlStr, e);
        }
    }
}

