/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api.event.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import java.io.IOException;
import java.util.Objects;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.event.CancelJobRequestEvent;
import org.kie.kogito.jobs.api.event.CreateProcessInstanceJobRequestEvent;
import org.kie.kogito.jobs.api.event.JobCloudEvent;
import org.kie.kogito.jobs.api.event.serialization.DeserializationException;
import org.kie.kogito.jobs.api.event.serialization.JobCloudEventSerializer;

public class JobCloudEventDeserializer {
    private final ObjectMapper objectMapper;

    public JobCloudEventDeserializer() {
        this.objectMapper = JobCloudEventSerializer.DEFAULT_OBJECT_MAPPER;
    }

    public JobCloudEventDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JobCloudEvent<?> deserialize(byte[] data) {
        try {
            CloudEvent cloudEvent = (CloudEvent)this.objectMapper.readValue(data, CloudEvent.class);
            CloudEventData cloudEventData = Objects.requireNonNull(cloudEvent.getData(), "JobCloudEvent data field must not be null");
            if (cloudEvent.getType().equals("CreateProcessInstanceJobRequest")) {
                Job job = (Job)this.objectMapper.readValue(cloudEventData.toBytes(), Job.class);
                return ((CreateProcessInstanceJobRequestEvent.Builder)((CreateProcessInstanceJobRequestEvent.Builder)CreateProcessInstanceJobRequestEvent.builder().withValuesFrom(cloudEvent)).withContextFrom(cloudEvent)).job(job).build();
            }
            if (cloudEvent.getType().equals("CancelJobRequest")) {
                CancelJobRequestEvent.JobId jobId = (CancelJobRequestEvent.JobId)this.objectMapper.readValue(cloudEventData.toBytes(), CancelJobRequestEvent.JobId.class);
                return ((CancelJobRequestEvent.Builder)((CancelJobRequestEvent.Builder)CancelJobRequestEvent.builder().withValuesFrom(cloudEvent)).withContextFrom(cloudEvent)).jobId(jobId.getId()).build();
            }
            throw new DeserializationException("Unknown JobCloudEvent event type: " + cloudEvent.getType());
        }
        catch (IOException e) {
            throw new DeserializationException("An error was produced during a JobCloudEvent deserialization: " + e.getMessage(), e);
        }
    }
}

