/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.temporal.ChronoUnit;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.api.JobCallbackPayload;
import org.kie.kogito.jobs.api.URIBuilder;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;

public class JobCallbackResourceDef {
    public static final String PROCESS_ID = "processId";
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String ROOT_PROCESS_ID = "rootProcessId";
    public static final String ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    public static final String NODE_INSTANCE_ID = "nodeInstanceId";
    public static final String TIMER_ID = "timerId";
    public static final String LIMIT = "limit";
    public static final String LIMIT_DEFAULT_VALUE = "0";
    public static final String JOBS_CALLBACK_URI = "/management/jobs";
    public static final String JOBS_CALLBACK_POST_URI = "{processId}/instances/{processInstanceId}/timers/{timerId}";

    private JobCallbackResourceDef() {
    }

    public static String buildCallbackURI(ProcessInstanceJobDescription description, String jobsCallbackEndpoint) {
        return URIBuilder.toURI(jobsCallbackEndpoint + "/management/jobs/" + description.processId() + "/instances/" + description.processInstanceId() + "/timers/" + description.timerId()).toString();
    }

    public static Job buildCallbackPatternJob(ProcessInstanceJobDescription description, String callback, ObjectMapper objectMapper) {
        return Job.builder().id(description.id()).correlationId(description.id()).recipient(JobCallbackResourceDef.buildRecipient(description, callback, objectMapper)).schedule((Schedule)JobCallbackResourceDef.buildSchedule(description)).build();
    }

    private static HttpRecipient<HttpRecipientJsonPayloadData> buildRecipient(ProcessInstanceJobDescription description, String callback, ObjectMapper objectMapper) {
        return HttpRecipient.builder().forJsonPayload().payload((HttpRecipientPayloadData)HttpRecipientJsonPayloadData.from((JsonNode)JobCallbackResourceDef.buildPayload(description, objectMapper))).url(callback).header("Content-Type", "application/json").header(PROCESS_ID, description.processId()).header(PROCESS_INSTANCE_ID, description.processInstanceId()).header(ROOT_PROCESS_ID, description.rootProcessId()).header(ROOT_PROCESS_INSTANCE_ID, description.rootProcessInstanceId()).header(NODE_INSTANCE_ID, description.nodeInstanceId()).build();
    }

    private static JsonNode buildPayload(ProcessInstanceJobDescription description, ObjectMapper objectMapper) {
        return objectMapper.valueToTree((Object)new JobCallbackPayload(description.id()));
    }

    private static TimerSchedule buildSchedule(ProcessInstanceJobDescription description) {
        return TimerSchedule.builder().startTime(description.expirationTime().get().toOffsetDateTime().truncatedTo(ChronoUnit.MILLIS)).repeatCount(Integer.valueOf(JobCallbackResourceDef.translateLimit(description.expirationTime().repeatLimit()))).delay(description.expirationTime().repeatInterval()).delayUnit(TemporalUnit.MILLIS).build();
    }

    private static int translateLimit(int repeatLimit) {
        if (repeatLimit < 0) {
            throw new IllegalArgumentException("The repeatLimit must be greater or equal han zero, but is: " + repeatLimit);
        }
        if (repeatLimit >= 1) {
            return repeatLimit - 1;
        }
        return repeatLimit;
    }
}

