/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.knative.eventing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.kie.kogito.addon.cloudevents.message.MessagePayloadDecorator;
import org.kie.kogito.addons.knative.eventing.CeOverrides;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeEventingMessagePayloadDecorator
implements MessagePayloadDecorator {
    public static final String K_CE_OVERRIDES = "K_CE_OVERRIDES";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeEventingMessagePayloadDecorator.class);
    private final ObjectMapper mapper = CloudEventUtils.Mapper.mapper();

    private JsonNode serializeEnvCeOverrides() {
        String ceOverridesValue = this.readEnvCeOverrides();
        if (ceOverridesValue == null || "".equals(ceOverridesValue)) {
            return null;
        }
        try {
            CeOverrides ceOverrides = (CeOverrides)this.mapper.readValue(ceOverridesValue, CeOverrides.class);
            return this.mapper.valueToTree(ceOverrides.getExtensions());
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("The variable {} doesn't have a valid JSON value: {}. Skipping override.", (Object)K_CE_OVERRIDES, (Object)e.getMessage());
            return null;
        }
    }

    String readEnvCeOverrides() {
        return System.getenv(K_CE_OVERRIDES);
    }

    public String decorate(String jsonPayload) {
        JsonNode ceOverrides = this.serializeEnvCeOverrides();
        if (ceOverrides == null) {
            LOGGER.debug("{} variable not present in the environment or it's empty", (Object)K_CE_OVERRIDES);
            return jsonPayload;
        }
        if (!CloudEventUtils.isCloudEvent((String)jsonPayload)) {
            LOGGER.warn("{} payload is not a valid CloudEvent, skipping {}.", (Object)jsonPayload, (Object)K_CE_OVERRIDES);
            return jsonPayload;
        }
        try {
            ObjectNode payloadNode = (ObjectNode)this.mapper.readTree(jsonPayload);
            return this.mapper.writeValueAsString((Object)payloadNode.setAll((ObjectNode)ceOverrides));
        }
        catch (IOException e) {
            LOGGER.error("Failed to override CloudEvents extensions with K_CE_OVERRIDES value", (Throwable)e);
            return jsonPayload;
        }
    }
}

