/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import org.kie.kogito.addons.k8s.Endpoint;

public class EndpointBuilder {
    public static final String SECURE_HTTP_PROTOCOL = "https";
    public static final String NONSECURE_HTTP_PROTOCOL = "http";
    public static final String PRIMARY_PORT_NAME = "primary-port-name";
    private static final int SECURE_PORT = 443;
    private static final int APP_SECURE_PORT = 8443;
    private static final String FORMAT_SVC_URL = "%s://%s:%s";
    private static final String CLUSTER_TYPE_NONE = "None";

    public Endpoint buildFrom(Service service) {
        if (service == null || this.isClusterIPEmpty(service.getSpec()) || service.getSpec().getPorts().isEmpty()) {
            return null;
        }
        Endpoint endpoint = new Endpoint();
        endpoint.setLabels(service.getMetadata().getLabels());
        String primaryPort = null;
        if (service.getMetadata().getLabels() != null) {
            primaryPort = (String)service.getMetadata().getLabels().get(PRIMARY_PORT_NAME);
        }
        String url = null;
        for (ServicePort port : service.getSpec().getPorts()) {
            if (primaryPort != null && !primaryPort.isEmpty() && primaryPort.equals(port.getName())) {
                endpoint.setUrl(this.urlForServiceAndPort(port, service, this.httpProtocolForPort(port.getPort())));
                endpoint.setName(port.getName());
                continue;
            }
            if (SECURE_HTTP_PROTOCOL.equals(port.getName())) {
                url = this.urlForServiceAndPort(port, service, SECURE_HTTP_PROTOCOL);
                if (NONSECURE_HTTP_PROTOCOL.equals(endpoint.getName())) {
                    endpoint.setUrl(url);
                    endpoint.setName(port.getName());
                } else {
                    endpoint.setUrlIfEmpty(port.getName(), url);
                }
            }
            if (NONSECURE_HTTP_PROTOCOL.equals(port.getName())) {
                url = this.urlForServiceAndPort(port, service, this.httpProtocolForPort(port.getPort()));
                endpoint.setUrlIfEmpty(port.getName(), url);
            }
            if (url == null) {
                url = this.urlForServiceAndPort(port, service, this.httpProtocolForPort(port.getPort()));
            }
            if (port.getName() != null && !port.getName().isEmpty()) {
                endpoint.addSecondaryUrl(port.getName(), url);
            }
            url = null;
        }
        if (endpoint.urlIsEmpty()) {
            endpoint.setUrl(this.urlForServiceAndPort((ServicePort)service.getSpec().getPorts().get(0), service, NONSECURE_HTTP_PROTOCOL));
            endpoint.removeSecondaryUrl(((ServicePort)service.getSpec().getPorts().get(0)).getName());
            return endpoint;
        }
        this.removeDuplicateUrls(endpoint);
        return endpoint;
    }

    private void removeDuplicateUrls(Endpoint endpoint) {
        if (endpoint.getUrl().equals(endpoint.getSecondaryUrl(NONSECURE_HTTP_PROTOCOL))) {
            endpoint.removeSecondaryUrl(NONSECURE_HTTP_PROTOCOL);
        }
        if (endpoint.getUrl().equals(endpoint.getSecondaryUrl(SECURE_HTTP_PROTOCOL))) {
            endpoint.removeSecondaryUrl(SECURE_HTTP_PROTOCOL);
        }
    }

    private String urlForServiceAndPort(ServicePort port, Service service, String protocol) {
        return String.format(FORMAT_SVC_URL, protocol, service.getSpec().getClusterIP(), port.getPort());
    }

    private String httpProtocolForPort(int port) {
        if (443 == port || 8443 == port) {
            return SECURE_HTTP_PROTOCOL;
        }
        return NONSECURE_HTTP_PROTOCOL;
    }

    private boolean isClusterIPEmpty(ServiceSpec serviceSpec) {
        return serviceSpec.getClusterIP() == null || serviceSpec.getClusterIP().isEmpty() || CLUSTER_TYPE_NONE.equals(serviceSpec.getClusterIP());
    }
}

