/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.k8s.workitems;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.kie.api.runtime.process.WorkItem;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;
import org.kie.kogito.addons.k8s.workitems.EndpointCallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDiscoveredEndpointCaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDiscoveredEndpointCaller.class);
    private static final List<String> INTERNAL_FIELDS = Arrays.asList("TaskName", "ActorId", "GroupId", "Priority", "Comment", "Skippable", "Content", "Model", "Namespace");
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;

    public AbstractDiscoveredEndpointCaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    }

    protected abstract EndpointDiscovery getEndpointDiscovery();

    public Map<String, Object> discoverAndCall(WorkItem workItem, String namespace, String workItemServiceKey, String httpMethod) {
        Map<String, Object> map;
        block10: {
            HashMap<String, Object> data = new HashMap<String, Object>(workItem.getParameters());
            String service = (String)data.remove(workItemServiceKey);
            List<Endpoint> endpoint = this.getEndpointDiscovery().findEndpoint(namespace, Collections.singletonMap(service, null));
            if (endpoint.isEmpty()) {
                throw new IllegalArgumentException("Kubernetes service with label " + service + " not found in the namespace " + namespace);
            }
            if (endpoint.size() > 1) {
                LOGGER.warn("Found more than one endpoint using labels {}:null. Returning the first one in the list. Try to be more specific in the query search.", (Object)service);
            }
            LOGGER.debug("Found endpoint for service {} in namespace {} with URL {}", new Object[]{service, namespace, endpoint.get(0).getUrl()});
            INTERNAL_FIELDS.forEach(data::remove);
            Request request = this.createRequest(String.format("%s/%s", endpoint.get(0).getUrl(), service), this.createRequestPayload(data), httpMethod);
            Response response = this.httpClient.newCall(request).execute();
            try {
                map = this.createResultsFromResponse(response, request.url().toString());
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EndpointCallerException(e);
                }
            }
            response.close();
        }
        return map;
    }

    private RequestBody createRequestPayload(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        try {
            String json = this.objectMapper.writeValueAsString(data);
            LOGGER.debug("Sending body {}", (Object)json);
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        }
        catch (Exception e) {
            throw new EndpointCallerException("Unexpected error when producing request payload", e);
        }
    }

    private Request createRequest(String url, RequestBody body, String httpMethod) {
        Request.Builder builder;
        switch (httpMethod) {
            case "DELETE": {
                builder = new Request.Builder().url(url).delete(body);
                break;
            }
            case "POST": {
                builder = new Request.Builder().url(url).post(body);
                break;
            }
            case "PUT": {
                builder = new Request.Builder().url(url).put(body);
                break;
            }
            default: {
                builder = new Request.Builder().url(url).get();
            }
        }
        return builder.build();
    }

    private Map<String, Object> createResultsFromResponse(Response response, String url) throws IOException {
        String payload = "";
        if (response.body() != null) {
            payload = response.body().string();
        }
        LOGGER.debug("Response code {} and payload {}", (Object)response.code(), (Object)payload);
        if (!response.isSuccessful()) {
            throw new EndpointCallerException("Unsuccessful response from service (" + url + "). Response: " + response.message() + " (code " + response.code() + ")");
        }
        return (Map)this.objectMapper.readValue(payload, Map.class);
    }
}

