/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.message;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.kogito.addon.cloudevents.message.MessagePayloadDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagePayloadDecoratorProvider
implements MessagePayloadDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessagePayloadDecoratorProvider.class);
    private final Set<MessagePayloadDecorator> payloadDecorators = new LinkedHashSet<MessagePayloadDecorator>();

    private MessagePayloadDecoratorProvider() {
        ServiceLoader<MessagePayloadDecorator> loader = ServiceLoader.load(MessagePayloadDecorator.class);
        loader.iterator().forEachRemaining(this.payloadDecorators::add);
        LOGGER.debug("Payload decorators loaded {}", this.payloadDecorators);
    }

    public static MessagePayloadDecoratorProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public Set<MessagePayloadDecorator> getPayloadDecorators() {
        return Collections.unmodifiableSet(this.payloadDecorators);
    }

    @Override
    public String decorate(String jsonPayload) {
        String decoratedPayload = jsonPayload;
        for (MessagePayloadDecorator d : this.payloadDecorators) {
            decoratedPayload = d.decorate(decoratedPayload);
        }
        LOGGER.debug("Message payload decorated {}", (Object)decoratedPayload);
        return jsonPayload;
    }

    private static class LazyHolder {
        private static final MessagePayloadDecoratorProvider INSTANCE = new MessagePayloadDecoratorProvider();

        private LazyHolder() {
        }
    }
}

