/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.util.CloseableIterator;
import org.kie.kogito.internal.utils.ConversionUtils;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

public class CacheProcessInstances
implements MutableProcessInstances {
    private final RemoteCache<String, byte[]> cache;
    private final ProcessInstanceMarshallerService marshaller;
    private final Process<?> process;
    private final boolean lock;

    public CacheProcessInstances(Process<?> process, RemoteCacheManager cacheManager, String templateName, boolean lock) {
        this.process = process;
        String cacheName = process.id() + "_store";
        this.cache = ConversionUtils.isEmpty((String)templateName) ? cacheManager.administration().getOrCreateCache(cacheName, DefaultTemplate.LOCAL) : cacheManager.administration().getOrCreateCache(cacheName, templateName);
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.lock = lock;
    }

    public Optional<? extends ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        return this.lock ? this.findWithLock(id, mode) : this.findInternal(id, mode);
    }

    private Optional<? extends ProcessInstance> findInternal(String id, ProcessInstanceReadMode mode) {
        byte[] data = (byte[])this.cache.get((Object)id);
        return data == null ? Optional.empty() : Optional.of(this.marshaller.unmarshallProcessInstance(data, this.process, mode));
    }

    private Optional<? extends ProcessInstance> findWithLock(String id, ProcessInstanceReadMode mode) {
        return Optional.ofNullable(this.cache.getWithMetadata((Object)id)).map(record -> this.unmarshall((MetadataValue)record, mode));
    }

    public Stream<? extends ProcessInstance> stream(ProcessInstanceReadMode mode) {
        if (this.lock) {
            CloseableIterator iterator = this.cache.retrieveEntriesWithMetadata(null, 1000);
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(v -> this.unmarshall((MetadataValue)v.getValue(), mode)).onClose(() -> ((CloseableIterator)iterator).close());
        }
        return this.cache.values().parallelStream().map(this.marshaller.createUnmarshallFunction(this.process, mode));
    }

    private <T> ProcessInstance<?> unmarshall(MetadataValue<T> versionedCache, ProcessInstanceReadMode mode) {
        ProcessInstance instance = this.marshaller.unmarshallProcessInstance((byte[])versionedCache.getValue(), this.process, mode);
        ((AbstractProcessInstance)instance).setVersion(versionedCache.getVersion());
        return instance;
    }

    public void update(String id, ProcessInstance instance) {
        try {
            this.updateStorage(id, instance, false);
        }
        finally {
            this.disconnect(id, instance);
        }
    }

    public void remove(String id) {
        this.cache.remove((Object)id);
    }

    public void create(String id, ProcessInstance instance) {
        this.updateStorage(id, instance, true);
    }

    protected void updateStorage(String id, ProcessInstance instance, boolean checkDuplicates) {
        if (this.isActive(instance)) {
            byte[] data = this.marshaller.marshallProcessInstance(instance);
            if (checkDuplicates) {
                byte[] existing = (byte[])this.cache.putIfAbsent((Object)id, (Object)data);
                if (existing != null) {
                    throw new ProcessInstanceDuplicatedException(id);
                }
                if (this.lock) {
                    ((AbstractProcessInstance)instance).setVersion(1L);
                }
            } else if (this.lock) {
                boolean success = this.cache.replaceWithVersion((Object)id, (Object)data, instance.version());
                if (!success) {
                    throw new ProcessInstanceOptimisticLockingException(id);
                }
            } else {
                this.cache.put((Object)id, (Object)data);
            }
        }
    }

    private void disconnect(String id, ProcessInstance instance) {
        if (this.lock) {
            this.reloadWithLock(id, instance);
        } else {
            this.reload(id, instance);
        }
    }

    private void reloadWithLock(String id, ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> {
            MetadataValue versionedCache = this.cache.getWithMetadata((Object)id);
            ((AbstractProcessInstance)instance).setVersion(versionedCache.getVersion());
            return (byte[])versionedCache.getValue();
        };
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    private void reload(String id, ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> (byte[])this.cache.get((Object)id);
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    public boolean exists(String id) {
        return this.cache.containsKey((Object)id);
    }

    public boolean lock() {
        return this.lock;
    }
}

