/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DatabaseType {
    ANSI("ansi", "process_instances"),
    ORACLE("Oracle", "PROCESS_INSTANCES"),
    POSTGRES("PostgreSQL", "process_instances");

    private static final Logger LOGGER;
    private final String dbIdentifier;
    private final String tableNamePattern;

    private DatabaseType(String dbIdentifier, String tableNamePattern) {
        this.dbIdentifier = dbIdentifier;
        this.tableNamePattern = tableNamePattern;
    }

    public String getDbIdentifier() {
        return this.dbIdentifier;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public static DatabaseType create(String dbIdentifier) {
        if (ORACLE.getDbIdentifier().equals(dbIdentifier)) {
            return ORACLE;
        }
        if (POSTGRES.getDbIdentifier().equals(dbIdentifier)) {
            return POSTGRES;
        }
        String msg = String.format("Unrecognized DB (%s), defaulting to ansi", dbIdentifier);
        LOGGER.warn(msg);
        return ANSI;
    }

    public static DatabaseType getDataBaseType(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String dbProductName = metaData.getDatabaseProductName();
        return DatabaseType.create(dbProductName);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DatabaseType.class);
    }
}

