/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.kie.kogito.persistence.jdbc.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRepository
extends Repository {
    private static final String PAYLOAD = "payload";
    private static final String VERSION = "version";
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRepository.class);
    private final DataSource dataSource;

    public GenericRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    void insertInternal(String processId, String processVersion, UUID id, byte[] payload) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO process_instances (id, payload, process_id, process_version, version) VALUES (?, ?, ?, ?, ?)");){
            statement.setString(1, id.toString());
            statement.setBytes(2, payload);
            statement.setString(3, processId);
            statement.setString(4, processVersion);
            statement.setLong(5, 0L);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    @Override
    void updateInternal(String processId, String processVersion, UUID id, byte[] payload) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("UPDATE process_instances SET payload = ? WHERE process_id = ? and id = ?", processVersion));){
            statement.setBytes(1, payload);
            statement.setString(2, processId);
            statement.setString(3, id.toString());
            if (processVersion != null) {
                statement.setString(4, processVersion);
            }
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean updateWithLock(String processId, String processVersion, UUID id, byte[] payload, long version) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("UPDATE process_instances SET payload = ?, version = ? WHERE process_id = ? and id = ? and version = ?", processVersion));
                try {
                    int count;
                    statement.setBytes(1, payload);
                    statement.setLong(2, version + 1L);
                    statement.setString(3, processId);
                    statement.setString(4, id.toString());
                    statement.setLong(5, version);
                    if (processVersion != null) {
                        statement.setString(6, processVersion);
                    }
                    boolean bl2 = bl = (count = statement.executeUpdate()) == 1;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating with lock process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean deleteInternal(String processId, String processVersion, UUID id) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("DELETE FROM process_instances WHERE process_id = ? and id = ?", processVersion));
                try {
                    int count;
                    statement.setString(1, processId);
                    statement.setString(2, id.toString());
                    if (processVersion != null) {
                        statement.setString(3, processVersion);
                    }
                    boolean bl2 = bl = (count = statement.executeUpdate()) == 1;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    private Repository.Record from(ResultSet rs) throws SQLException {
        return new Repository.Record(rs.getBytes(PAYLOAD), rs.getLong(VERSION));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Optional<Repository.Record> findByIdInternal(String processId, String processVersion, UUID id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("SELECT payload, version FROM process_instances WHERE process_id = ? and id = ?", processVersion));){
            statement.setString(1, processId);
            statement.setString(2, id.toString());
            if (processVersion != null) {
                statement.setString(3, processVersion);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return Optional.empty();
                Optional<Repository.Record> optional = Optional.of(this.from(resultSet));
                return optional;
            }
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    @Override
    Stream<Repository.Record> findAllInternal(final String processId, String processVersion) {
        CloseableWrapper close = new CloseableWrapper();
        try {
            Connection connection = close.nest(this.dataSource.getConnection());
            PreparedStatement statement = close.nest(connection.prepareStatement(GenericRepository.sqlIncludingVersion("SELECT payload, version FROM process_instances WHERE process_id = ?", processVersion)));
            statement.setString(1, processId);
            if (processVersion != null) {
                statement.setString(2, processVersion);
            }
            final ResultSet resultSet = close.nest(statement.executeQuery());
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<Repository.Record>(Long.MAX_VALUE, 16){

                @Override
                public boolean tryAdvance(Consumer<? super Repository.Record> action) {
                    try {
                        boolean hasNext = resultSet.next();
                        if (hasNext) {
                            action.accept(GenericRepository.this.from(resultSet));
                        }
                        return hasNext;
                    }
                    catch (SQLException e) {
                        throw GenericRepository.this.uncheckedException(e, "Error finding all process instances, for processId %s", processId);
                    }
                }
            }, false).onClose(close);
        }
        catch (SQLException e) {
            try {
                close.close();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", processId);
        }
    }

    private static String sqlIncludingVersion(String statement, String processVersion) {
        return statement + " " + (processVersion == null ? "and process_version is null" : "and process_version = ?");
    }

    private static class CloseableWrapper
    implements Runnable {
        private Deque<AutoCloseable> wrapped = new ArrayDeque<AutoCloseable>();

        private CloseableWrapper() {
        }

        public <T extends AutoCloseable> T nest(T c) {
            this.wrapped.addFirst(c);
            return c;
        }

        @Override
        public void run() {
            try {
                this.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Error closing resources", ex);
            }
        }

        public void close() throws Exception {
            Exception exception = null;
            for (AutoCloseable wrap : this.wrapped) {
                try {
                    wrap.close();
                }
                catch (Exception ex) {
                    if (exception != null) {
                        ex.addSuppressed(exception);
                    }
                    exception = ex;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

