/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.processor;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.model.SVGSummary;
import org.kie.kogito.svg.model.Transformation;
import org.kie.kogito.svg.processor.SVGProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSVGProcessor
implements SVGProcessor {
    protected Document svgDocument;
    protected SVGSummary summary = new SVGSummary();
    protected boolean mapById = true;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public AbstractSVGProcessor(Document svgDocument, boolean mapById) {
        this.svgDocument = svgDocument;
        this.mapById = mapById;
        this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    @Override
    public void transform(Transformation t) {
        t.transform(this.summary);
    }

    @Override
    public String getSVG() {
        String string;
        StringWriter writer = new StringWriter();
        try {
            DOMSource domSource = new DOMSource(this.svgDocument.getFirstChild());
            StreamResult result = new StreamResult(writer);
            Transformer transformer = this.transformerFactory.newTransformer();
            ((Element)this.svgDocument.getFirstChild()).setAttribute("viewBox", "0 0 " + ((Element)this.svgDocument.getFirstChild()).getAttribute("width") + " " + ((Element)this.svgDocument.getFirstChild()).getAttribute("height"));
            ((Element)this.svgDocument.getFirstChild()).removeAttribute("width");
            ((Element)this.svgDocument.getFirstChild()).removeAttribute("height");
            transformer.transform(domSource, result);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new ProcessSVGException("Could not transform svg", e);
            }
        }
        writer.close();
        return string;
    }

    @Override
    public void defaultCompletedTransformation(String nodeId) {
        this.defaultCompletedTransformation(nodeId, "#C0C0C0", "#030303");
    }

    @Override
    public void defaultActiveTransformation(String nodeId) {
        this.defaultActiveTransformation(nodeId, "#FF0000");
    }
}

