/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.processor.SVGProcessor;
import org.kie.kogito.svg.processor.SVGProcessorFactory;
import org.w3c.dom.Document;

public class SVGImageProcessor {
    private SVGProcessor svgProcessor;

    public SVGImageProcessor(InputStream svg) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(svg);
            this.svgProcessor = new SVGProcessorFactory().create(doc);
            this.svgProcessor.processNodes(doc.getChildNodes());
        }
        catch (Exception e) {
            throw new ProcessSVGException("Could not parse svg", e);
        }
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active) {
        return SVGImageProcessor.transform(svg, completed, active, null, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks) {
        return SVGImageProcessor.transform(svg, completed, active, subProcessLinks, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor) {
        SVGProcessor processor = new SVGImageProcessor(svg).getProcessor();
        for (String string : completed) {
            if (active.contains(string)) continue;
            processor.defaultCompletedTransformation(string, completedNodeColor, completedNodeBorderColor);
        }
        for (String string : active) {
            processor.defaultActiveTransformation(string, activeNodeBorderColor);
        }
        if (subProcessLinks != null) {
            for (Map.Entry entry : subProcessLinks.entrySet()) {
                processor.defaultSubProcessLinkTransformation((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return processor.getSVG();
    }

    public SVGProcessor getProcessor() {
        return this.svgProcessor;
    }
}

