/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.quarkus;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.addon.cloudevents.quarkus.ChannelResolver;
import org.kie.kogito.event.InputTriggerAware;
import org.kie.kogito.event.OutputTriggerAware;

@ApplicationScoped
public class ProcessChannelResolver
implements ChannelResolver {
    @Inject
    private Instance<InputTriggerAware> inputChannelsProvider;
    @Inject
    private Instance<OutputTriggerAware> outputChannelsProvider;
    private Set<String> inputChannels;
    private Set<String> outputChannels;

    @Override
    public Collection<String> getOuputChannels() {
        return this.outputChannels;
    }

    @Override
    public Collection<String> getInputChannels() {
        return this.inputChannels;
    }

    @PostConstruct
    private void init() {
        this.inputChannels = this.getChannels(this.inputChannelsProvider, InputTriggerAware::getInputTrigger);
        this.outputChannels = this.getChannels(this.outputChannelsProvider, OutputTriggerAware::getOutputTrigger);
    }

    private <T> Set<String> getChannels(Instance<T> channelProvider, Function<T, String> triggerResolver) {
        HashSet channels = new HashSet();
        channelProvider.forEach(instance -> channels.add((String)triggerResolver.apply(instance)));
        return Collections.unmodifiableSet(channels);
    }
}

